/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class RootLoggerAction
extends Action {
    Logger root;
    boolean inError = false;

    @Override
    public void begin(InterpretationContext ec2, String name, Attributes attributes) {
        this.inError = false;
        LoggerContext loggerContext = (LoggerContext)this.context;
        this.root = loggerContext.getLogger("ROOT");
        String levelStr = ec2.subst(attributes.getValue("level"));
        if (!OptionHelper.isEmpty(levelStr)) {
            Level level = Level.toLevel(levelStr);
            this.addInfo("Setting level of ROOT logger to " + level);
            this.root.setLevel(level);
        }
        ec2.pushObject(this.root);
    }

    @Override
    public void end(InterpretationContext ec2, String name) {
        if (this.inError) {
            return;
        }
        Object o2 = ec2.peekObject();
        if (o2 != this.root) {
            this.addWarn("The object on the top the of the stack is not the root logger");
            this.addWarn("It is: " + o2);
        } else {
            ec2.popObject();
        }
    }

    public void finish(InterpretationContext ec2) {
    }
}

