/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMarginBorder;
import com.formdev.flatlaf.ui.FlatMenuBarUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JMenuBar;
import javax.swing.UIManager;

public class FlatMenuBarBorder
extends FlatMarginBorder
implements FlatStylingSupport.StyleableBorder {
    @FlatStylingSupport.Styleable
    protected Color borderColor = UIManager.getColor("MenuBar.borderColor");

    @Override
    public Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObject(this, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (!this.showBottomSeparator(c2)) {
            return;
        }
        float lineHeight = UIScale.scale(1.0f);
        FlatUIUtils.paintFilledRectangle(g2, this.borderColor, x2, (float)(y2 + height) - lineHeight, width, lineHeight);
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        Insets margin = c2 instanceof JMenuBar ? ((JMenuBar)c2).getMargin() : new Insets(0, 0, 0, 0);
        insets.top = UIScale.scale(margin.top);
        insets.left = UIScale.scale(margin.left);
        insets.bottom = UIScale.scale(margin.bottom + 1);
        insets.right = UIScale.scale(margin.right);
        return insets;
    }

    protected boolean showBottomSeparator(Component c2) {
        return !FlatMenuBarUI.useUnifiedBackground(c2);
    }
}

