/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public final class InplaceBoxBlurFilter {
    private InplaceBoxBlurFilter() {
    }

    public static void horizontalPass(@NotNull Raster src, @NotNull WritableRaster dst, int skipX, int skipY, int boxSize, int loc) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (width < 2 * skipX + boxSize) {
            return;
        }
        if (height < 2 * skipY) {
            return;
        }
        int srcScanStride = ImageUtil.getINT_RGBA_ScanlineStride(src);
        int dstScanStride = ImageUtil.getINT_RGBA_ScanlineStride(dst);
        int srcOff = ImageUtil.getINT_RGBA_DataOffset(src);
        int dstOff = ImageUtil.getINT_RGBA_DataOffset(dst);
        int[] srcPixels = ImageUtil.getINT_RGBA_DataBank(src);
        int[] dstPixels = ImageUtil.getINT_RGBA_DataBank(dst);
        int[] buffer = new int[boxSize];
        int scale = 0x1000000 / boxSize;
        for (int y2 = skipY; y2 < height - skipY; ++y2) {
            int curr;
            int sp = srcOff + y2 * srcScanStride;
            int dp2 = dstOff + y2 * dstScanStride;
            int rowEnd = sp + (width - skipX);
            int k2 = 0;
            int sumA = 0;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            int end = (sp += skipX) + boxSize;
            while (sp < end) {
                curr = buffer[k2] = srcPixels[sp];
                sumA += curr >>> 24;
                sumR += curr >> 16 & 0xFF;
                sumG += curr >> 8 & 0xFF;
                sumB += curr & 0xFF;
                ++k2;
                ++sp;
            }
            int prev = dstPixels[dp2 += skipX + loc] = sumA * scale & 0xFF000000 | (sumR * scale & 0xFF000000) >>> 8 | (sumG * scale & 0xFF000000) >>> 16 | (sumB * scale & 0xFF000000) >>> 24;
            ++dp2;
            k2 = 0;
            while (sp < rowEnd) {
                curr = buffer[k2];
                if (curr == srcPixels[sp]) {
                    dstPixels[dp2] = prev;
                } else {
                    sumA -= curr >>> 24;
                    sumR -= curr >> 16 & 0xFF;
                    sumG -= curr >> 8 & 0xFF;
                    sumB -= curr & 0xFF;
                    curr = buffer[k2] = srcPixels[sp];
                    prev = dstPixels[dp2] = (sumA += curr >>> 24) * scale & 0xFF000000 | ((sumR += curr >> 16 & 0xFF) * scale & 0xFF000000) >>> 8 | ((sumG += curr >> 8 & 0xFF) * scale & 0xFF000000) >>> 16 | ((sumB += curr & 0xFF) * scale & 0xFF000000) >>> 24;
                }
                k2 = (k2 + 1) % boxSize;
                ++sp;
                ++dp2;
            }
        }
    }

    public static void verticalPass(@NotNull Raster src, @NotNull WritableRaster dst, int skipX, int skipY, int boxSize, int loc) {
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        if (w2 < 2 * skipX) {
            return;
        }
        if (h2 < 2 * skipY + boxSize) {
            return;
        }
        int srcScanStride = ImageUtil.getINT_RGBA_ScanlineStride(src);
        int dstScanStride = ImageUtil.getINT_RGBA_ScanlineStride(dst);
        int srcOff = ImageUtil.getINT_RGBA_DataOffset(src);
        int dstOff = ImageUtil.getINT_RGBA_DataOffset(dst);
        int[] srcPixels = ImageUtil.getINT_RGBA_DataBank(src);
        int[] dstPixels = ImageUtil.getINT_RGBA_DataBank(dst);
        int[] buffer = new int[boxSize];
        int scale = 0x1000000 / boxSize;
        for (int x2 = skipX; x2 < w2 - skipX; ++x2) {
            int curr;
            int sp = srcOff + x2;
            int dp2 = dstOff + x2;
            int colEnd = sp + (h2 - skipY) * srcScanStride;
            int k2 = 0;
            int sumA = 0;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            int end = (sp += skipY * srcScanStride) + boxSize * srcScanStride;
            while (sp < end) {
                curr = buffer[k2] = srcPixels[sp];
                sumA += curr >>> 24;
                sumR += curr >> 16 & 0xFF;
                sumG += curr >> 8 & 0xFF;
                sumB += curr & 0xFF;
                ++k2;
                sp += srcScanStride;
            }
            int prev = dstPixels[dp2 += (skipY + loc) * dstScanStride] = sumA * scale & 0xFF000000 | (sumR * scale & 0xFF000000) >>> 8 | (sumG * scale & 0xFF000000) >>> 16 | (sumB * scale & 0xFF000000) >>> 24;
            dp2 += dstScanStride;
            k2 = 0;
            while (sp < colEnd) {
                curr = buffer[k2];
                if (curr == srcPixels[sp]) {
                    dstPixels[dp2] = prev;
                } else {
                    sumA -= curr >>> 24;
                    sumR -= curr >> 16 & 0xFF;
                    sumG -= curr >> 8 & 0xFF;
                    sumB -= curr & 0xFF;
                    curr = buffer[k2] = srcPixels[sp];
                    prev = dstPixels[dp2] = (sumA += curr >>> 24) * scale & 0xFF000000 | ((sumR += curr >> 16 & 0xFF) * scale & 0xFF000000) >>> 8 | ((sumG += curr >> 8 & 0xFF) * scale & 0xFF000000) >>> 16 | ((sumB += curr & 0xFF) * scale & 0xFF000000) >>> 24;
                }
                k2 = (k2 + 1) % boxSize;
                sp += srcScanStride;
                dp2 += dstScanStride;
            }
        }
    }
}

