/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.prototype;

import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Transformable {
    default public boolean shouldTransform() {
        return true;
    }

    @Nullable
    public AffineTransform transform();

    @NotNull
    public Point2D transformOrigin(@NotNull MeasureContext var1);

    default public void applyTransform(@NotNull Graphics2D g2, @NotNull RenderContext context) {
        AffineTransform transform = this.transform();
        if (transform != null) {
            Point2D transformOrigin = this.transformOrigin(context.measureContext());
            AffineTransform conjugate = AffineTransform.getTranslateInstance(transformOrigin.getX(), transformOrigin.getY());
            conjugate.concatenate(transform);
            conjugate.translate(-transformOrigin.getX(), -transformOrigin.getY());
            g2.transform(conjugate);
            context.userSpaceTransform().concatenate(conjugate);
        }
    }

    default public Shape transformShape(@NotNull Shape shape, @NotNull MeasureContext measureContext) {
        AffineTransform transform = this.transform();
        if (transform != null) {
            Point2D transformOrigin = this.transformOrigin(measureContext);
            AffineTransform at2 = new AffineTransform();
            at2.translate(transformOrigin.getX(), transformOrigin.getY());
            at2.concatenate(transform);
            at2.translate(-transformOrigin.getX(), -transformOrigin.getY());
            return at2.createTransformedShape(shape);
        }
        return shape;
    }
}

