/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser.css.impl;

import com.github.weisj.jsvg.parser.css.impl.ParserException;
import com.github.weisj.jsvg.parser.css.impl.Token;
import com.github.weisj.jsvg.parser.css.impl.TokenType;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class Lexer {
    private static final Logger LOGGER = Logger.getLogger(Lexer.class.getName());
    @NotNull
    private final List<char[]> input;
    private int listIndex = 0;
    private int index = 0;
    private boolean inRuleDefinition;
    private boolean parsingRaw;

    public Lexer(@NotNull List<char[]> input) {
        this.input = input;
    }

    @NotNull
    public Token nextToken() {
        this.consumeWhiteSpace();
        if (this.inRuleDefinition && this.parsingRaw) {
            this.parsingRaw = false;
            return new Token(TokenType.RAW_DATA, this.readWhile(c2 -> c2.charValue() != ';' && c2.charValue() != '}'));
        }
        if (this.isEof()) {
            return new Token(TokenType.EOF);
        }
        char c3 = this.current();
        switch (c3) {
            case '{': {
                this.inRuleDefinition = true;
                this.parsingRaw = false;
                this.next();
                return new Token(TokenType.CURLY_OPEN);
            }
            case '}': {
                this.inRuleDefinition = false;
                this.parsingRaw = false;
                this.next();
                return new Token(TokenType.CURLY_CLOSE);
            }
            case ':': {
                this.parsingRaw = true;
                this.next();
                return new Token(TokenType.COLON);
            }
            case ';': {
                this.next();
                return new Token(TokenType.SEMICOLON);
            }
            case ',': {
                this.next();
                return new Token(TokenType.COMMA);
            }
            case '.': {
                this.next();
                return new Token(TokenType.CLASS_NAME, this.readIdentifier());
            }
            case '#': {
                this.next();
                return new Token(TokenType.ID_NAME, this.readIdentifier());
            }
        }
        return new Token(TokenType.IDENTIFIER, this.readIdentifier());
    }

    private boolean isEof() {
        return this.listIndex >= this.input.size() || this.listIndex == this.input.size() - 1 && this.index >= this.input.get(this.listIndex).length;
    }

    private void consumeWhiteSpace() {
        while (Character.isWhitespace(this.current())) {
            this.next();
        }
    }

    private boolean isIdentifierCharStart(char c2) {
        if ('A' <= c2 && c2 <= 'Z') {
            return true;
        }
        if ('a' <= c2 && c2 <= 'z') {
            return true;
        }
        if (c2 == '-') {
            return true;
        }
        return c2 == '_';
    }

    private boolean isIdentifierChar(char c2) {
        if (this.isIdentifierCharStart(c2)) {
            return true;
        }
        return '0' <= c2 && c2 <= '9';
    }

    @NotNull
    private String readIdentifier() {
        if (!this.isIdentifierCharStart(this.current()) || !this.isIdentifierChar(this.current())) {
            LOGGER.warning(() -> MessageFormat.format("Identifier starting with unexpected char ''{0}''", Character.valueOf(this.current())));
            if (this.readWhile(this::isIdentifierChar).isEmpty()) {
                this.next();
            }
            throw new ParserException();
        }
        return this.readWhile(this::isIdentifierChar);
    }

    @NotNull
    private String readWhile(@NotNull Predicate<Character> filter) {
        if (this.isEof()) {
            return "";
        }
        int startListIndex = this.listIndex;
        int startIndex = this.index;
        while (!this.isEof() && filter.test(Character.valueOf(this.current()))) {
            this.next();
        }
        int endListIndex = this.isEof() ? this.input.size() - 1 : this.listIndex;
        int endIndex = this.isEof() ? this.input.get(endListIndex).length - 1 : this.index;
        StringBuilder builder = new StringBuilder();
        int start = startIndex;
        for (int i2 = startListIndex; i2 <= endListIndex; ++i2) {
            char[] segment = this.input.get(i2);
            int end = i2 == endListIndex ? endIndex : segment.length - 1;
            builder.append(String.valueOf(segment, start, end - start));
            start = 0;
        }
        return builder.toString();
    }

    private char current() {
        if (this.isEof()) {
            return '\u0000';
        }
        return this.input.get(this.listIndex)[this.index];
    }

    private void next() {
        ++this.index;
        if (this.index >= this.input.get(this.listIndex).length && this.listIndex + 1 < this.input.size()) {
            this.index = 0;
            ++this.listIndex;
        }
    }
}

