/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer.jdk;

import com.github.weisj.jsvg.renderer.jdk.SVGMultipleGradientPaint;
import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

abstract class SVGMultipleGradientPaintContext
implements PaintContext {
    private static final float MIN_INTERVAL_LENGTH = 0.001f;
    protected ColorModel model;
    private static final ColorModel XRGB_MODEL = new DirectColorModel(24, 0xFF0000, 65280, 255);
    protected static ColorModel cachedModel;
    protected static WeakReference<Raster> cached;
    protected Raster saved;
    protected MultipleGradientPaint.CycleMethod cycleMethod;
    protected MultipleGradientPaint.ColorSpaceType colorSpace;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    protected boolean isSimpleLookup;
    protected int fastGradientArraySize;
    protected int[] gradient;
    private int[][] gradients;
    private float[] normalizedIntervals;
    private final float[] fractions;
    private int transparencyTest;
    private static final int[] SRGBtoLinearRGB;
    private static final int[] LinearRGBtoSRGB;
    protected static final int GRADIENT_SIZE = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int MAX_GRADIENT_ARRAY_SIZE = 5000;

    protected SVGMultipleGradientPaintContext(@NotNull SVGMultipleGradientPaint mgp, @NotNull AffineTransform t2, float @NotNull [] fractions, @NotNull @NotNull Color @NotNull [] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace) {
        int[][] gradients;
        AffineTransform tInv;
        try {
            t2.invert();
            tInv = t2;
        }
        catch (NoninvertibleTransformException e2) {
            tInv = new AffineTransform();
        }
        double[] m2 = new double[6];
        tInv.getMatrix(m2);
        this.a00 = (float)m2[0];
        this.a10 = (float)m2[1];
        this.a01 = (float)m2[2];
        this.a11 = (float)m2[3];
        this.a02 = (float)m2[4];
        this.a12 = (float)m2[5];
        this.cycleMethod = cycleMethod;
        this.colorSpace = colorSpace;
        this.fractions = fractions;
        int[] gradient = mgp.gradient != null ? mgp.gradient.get() : null;
        int[][] nArray = gradients = mgp.gradients != null ? mgp.gradients.get() : null;
        if (gradient == null && gradients == null) {
            this.calculateLookupData(colors);
            mgp.model = this.model;
            mgp.normalizedIntervals = this.normalizedIntervals;
            mgp.isSimpleLookup = this.isSimpleLookup;
            if (this.isSimpleLookup) {
                mgp.fastGradientArraySize = this.fastGradientArraySize;
                mgp.gradient = new SoftReference<int[]>(this.gradient);
            } else {
                mgp.gradients = new SoftReference<int[][]>(this.gradients);
            }
        } else {
            this.model = mgp.model;
            this.normalizedIntervals = mgp.normalizedIntervals;
            this.isSimpleLookup = mgp.isSimpleLookup;
            this.gradient = gradient;
            this.fastGradientArraySize = mgp.fastGradientArraySize;
            this.gradients = gradients;
        }
    }

    private void calculateLookupData(Color[] colors) {
        int i2;
        Color[] normalizedColors;
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            normalizedColors = new Color[colors.length];
            for (i2 = 0; i2 < colors.length; ++i2) {
                int argb = colors[i2].getRGB();
                int a2 = argb >>> 24;
                int r2 = SRGBtoLinearRGB[argb >> 16 & 0xFF];
                int g2 = SRGBtoLinearRGB[argb >> 8 & 0xFF];
                int b2 = SRGBtoLinearRGB[argb & 0xFF];
                normalizedColors[i2] = new Color(r2, g2, b2, a2);
            }
        } else {
            normalizedColors = colors;
        }
        this.normalizedIntervals = new float[this.fractions.length - 1];
        for (i2 = 0; i2 < this.normalizedIntervals.length; ++i2) {
            this.normalizedIntervals[i2] = this.fractions[i2 + 1] - this.fractions[i2];
        }
        this.transparencyTest = -16777216;
        this.gradients = new int[this.normalizedIntervals.length][];
        float Imin = 1.0f;
        for (float interval : this.normalizedIntervals) {
            if (!(interval > 0.001f)) continue;
            Imin = Math.min(Imin, interval);
        }
        int estimatedSize = 0;
        for (float normalizedInterval : this.normalizedIntervals) {
            estimatedSize += (int)(normalizedInterval / Imin * 256.0f);
        }
        if (estimatedSize > 5000) {
            this.calculateMultipleArrayGradient(normalizedColors);
        } else {
            this.calculateSingleArrayGradient(normalizedColors, Imin);
        }
        this.model = this.transparencyTest >>> 24 == 255 ? XRGB_MODEL : ColorModel.getRGBdefault();
    }

    private void calculateSingleArrayGradient(Color[] colors, float Imin) {
        this.isSimpleLookup = true;
        int gradientsTot = 1;
        for (int i2 = 0; i2 < this.gradients.length; ++i2) {
            int nGradients = (int)(this.normalizedIntervals[i2] / Imin * 255.0f);
            gradientsTot += nGradients;
            this.gradients[i2] = new int[nGradients];
            int rgb1 = colors[i2].getRGB();
            int rgb2 = colors[i2 + 1].getRGB();
            this.interpolate(rgb1, rgb2, this.gradients[i2]);
            this.transparencyTest &= rgb1;
            this.transparencyTest &= rgb2;
        }
        this.gradient = new int[gradientsTot];
        int curOffset = 0;
        for (int[] ints : this.gradients) {
            System.arraycopy(ints, 0, this.gradient, curOffset, ints.length);
            curOffset += ints.length;
        }
        this.gradient[this.gradient.length - 1] = colors[colors.length - 1].getRGB();
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            for (int i3 = 0; i3 < this.gradient.length; ++i3) {
                this.gradient[i3] = this.convertEntireColorLinearRGBtoSRGB(this.gradient[i3]);
            }
        }
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void calculateMultipleArrayGradient(Color[] colors) {
        this.isSimpleLookup = false;
        for (int i2 = 0; i2 < this.gradients.length; ++i2) {
            this.gradients[i2] = new int[256];
            int rgb1 = colors[i2].getRGB();
            int rgb2 = colors[i2 + 1].getRGB();
            this.interpolate(rgb1, rgb2, this.gradients[i2]);
            this.transparencyTest &= rgb1;
            this.transparencyTest &= rgb2;
        }
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            for (int j2 = 0; j2 < this.gradients.length; ++j2) {
                for (int i3 = 0; i3 < this.gradients[j2].length; ++i3) {
                    this.gradients[j2][i3] = this.convertEntireColorLinearRGBtoSRGB(this.gradients[j2][i3]);
                }
            }
        }
    }

    private void interpolate(int rgb1, int rgb2, int[] output) {
        float stepSize = 1.0f / (float)output.length;
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int da2 = (rgb2 >> 24 & 0xFF) - a1;
        int dr2 = (rgb2 >> 16 & 0xFF) - r1;
        int dg2 = (rgb2 >> 8 & 0xFF) - g1;
        int db2 = (rgb2 & 0xFF) - b1;
        for (int i2 = 0; i2 < output.length; ++i2) {
            output[i2] = (int)((double)((float)a1 + (float)(i2 * da2) * stepSize) + 0.5) << 24 | (int)((double)((float)r1 + (float)(i2 * dr2) * stepSize) + 0.5) << 16 | (int)((double)((float)g1 + (float)(i2 * dg2) * stepSize) + 0.5) << 8 | (int)((double)((float)b1 + (float)(i2 * db2) * stepSize) + 0.5);
        }
    }

    private int convertEntireColorLinearRGBtoSRGB(int rgb) {
        int a1 = rgb >> 24 & 0xFF;
        int r1 = rgb >> 16 & 0xFF;
        int g1 = rgb >> 8 & 0xFF;
        int b1 = rgb & 0xFF;
        r1 = LinearRGBtoSRGB[r1];
        g1 = LinearRGBtoSRGB[g1];
        b1 = LinearRGBtoSRGB[b1];
        return a1 << 24 | r1 << 16 | g1 << 8 | b1;
    }

    protected final int indexIntoGradientsArrays(float position) {
        if (this.cycleMethod == MultipleGradientPaint.CycleMethod.NO_CYCLE) {
            if (position > 1.0f) {
                position = 1.0f;
            } else if (position < 0.0f) {
                position = 0.0f;
            }
        } else if (this.cycleMethod == MultipleGradientPaint.CycleMethod.REPEAT) {
            if ((position -= (float)((int)position)) < 0.0f) {
                position += 1.0f;
            }
        } else {
            if (position < 0.0f) {
                position = -position;
            }
            int part = (int)position;
            position -= (float)part;
            if ((part & 1) == 1) {
                position = 1.0f - position;
            }
        }
        if (this.isSimpleLookup) {
            return this.gradient[(int)(position * (float)this.fastGradientArraySize)];
        }
        for (int i2 = 0; i2 < this.gradients.length; ++i2) {
            if (!(position < this.fractions[i2 + 1])) continue;
            float delta = position - this.fractions[i2];
            int index = (int)(delta / this.normalizedIntervals[i2] * 255.0f);
            return this.gradients[i2][index];
        }
        return this.gradients[this.gradients.length - 1][255];
    }

    private static int convertSRGBtoLinearRGB(int color) {
        float input = (float)color / 255.0f;
        float output = input <= 0.04045f ? input / 12.92f : (float)Math.pow(((double)input + 0.055) / 1.055, 2.4);
        return Math.round(output * 255.0f);
    }

    private static int convertLinearRGBtoSRGB(int color) {
        float input = (float)color / 255.0f;
        float output = (double)input <= 0.0031308 ? input * 12.92f : 1.055f * (float)Math.pow(input, 0.4166666666666667) - 0.055f;
        return Math.round(output * 255.0f);
    }

    @Override
    public final Raster getRaster(int x2, int y2, int w2, int h2) {
        Raster raster = this.saved;
        if (raster == null || raster.getWidth() < w2 || raster.getHeight() < h2) {
            this.saved = raster = SVGMultipleGradientPaintContext.getCachedRaster(this.model, w2, h2);
        }
        DataBufferInt rasterDB = (DataBufferInt)raster.getDataBuffer();
        int[] pixels = rasterDB.getData(0);
        int off = rasterDB.getOffset();
        int scanlineStride = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int adjust = scanlineStride - w2;
        this.fillRaster(pixels, off, adjust, x2, y2, w2, h2);
        return raster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static synchronized Raster getCachedRaster(ColorModel cm2, int w2, int h2) {
        Raster ras;
        if (Objects.equals(cm2, cachedModel) && cached != null && (ras = (Raster)cached.get()) != null && ras.getWidth() >= w2 && ras.getHeight() >= h2) {
            cached = null;
            return ras;
        }
        return cm2.createCompatibleWritableRaster(w2, h2);
    }

    private static synchronized void putCachedRaster(ColorModel cm2, Raster ras) {
        Raster cras;
        if (cached != null && (cras = (Raster)cached.get()) != null) {
            int cw2 = cras.getWidth();
            int ch2 = cras.getHeight();
            int iw2 = ras.getWidth();
            int ih2 = ras.getHeight();
            if (cw2 >= iw2 && ch2 >= ih2) {
                return;
            }
            if (cw2 * ch2 >= iw2 * ih2) {
                return;
            }
        }
        cachedModel = cm2;
        cached = new WeakReference<Raster>(ras);
    }

    @Override
    public final void dispose() {
        if (this.saved != null) {
            SVGMultipleGradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    @Override
    public final ColorModel getColorModel() {
        return this.model;
    }

    static {
        SRGBtoLinearRGB = new int[256];
        LinearRGBtoSRGB = new int[256];
        for (int k2 = 0; k2 < 256; ++k2) {
            SVGMultipleGradientPaintContext.SRGBtoLinearRGB[k2] = SVGMultipleGradientPaintContext.convertSRGBtoLinearRGB(k2);
            SVGMultipleGradientPaintContext.LinearRGBtoSRGB[k2] = SVGMultipleGradientPaintContext.convertLinearRGBtoSRGB(k2);
        }
    }
}

