/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer.jdk;

import com.github.weisj.jsvg.renderer.jdk.SVGMultipleGradientPaintContext;
import com.github.weisj.jsvg.renderer.jdk.SVGRadialGradientPaint;
import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;

final class SVGRadialGradientPaintContext
extends SVGMultipleGradientPaintContext {
    private final boolean isSimpleFocus;
    private final boolean isNonCyclic;
    private final float centerX;
    private final float centerY;
    private float focusX;
    private float focusY;
    private final float radiusSq;
    private final float focusRadius;
    private final float focusRadiusSq;
    private final float constA;
    private final float constB;
    private final float gDeltaDelta;
    private final float trivial;
    private static final float FOCUS_CLAMP_DOWNSCALE = 0.99f;
    private static final int SQRT_LUT_SIZE = 2048;
    private static final float[] sqrtLookup = new float[2049];

    SVGRadialGradientPaintContext(@NotNull SVGRadialGradientPaint paint, @NotNull AffineTransform t2, float cx2, float cy2, float r2, float fx2, float fy2, float fr2, float @NotNull [] fractions, @NotNull @NotNull Color @NotNull [] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace) {
        super(paint, t2, fractions, colors, cycleMethod, colorSpace);
        this.centerX = cx2;
        this.centerY = cy2;
        this.focusX = fx2;
        this.focusY = fy2;
        this.isSimpleFocus = this.focusX == this.centerX && this.focusY == this.centerY && fr2 == 0.0f;
        this.isNonCyclic = cycleMethod == MultipleGradientPaint.CycleMethod.NO_CYCLE;
        this.radiusSq = r2 * r2;
        this.focusRadius = fr2;
        this.focusRadiusSq = fr2 * fr2;
        float dX2 = this.focusX - this.centerX;
        float dY2 = this.focusY - this.centerY;
        double distSq = dX2 * dX2 + dY2 * dY2;
        if (distSq > (double)(this.radiusSq * 0.99f)) {
            float scale = (float)Math.sqrt((double)(this.radiusSq * 0.99f) / distSq);
            this.focusX = this.centerX + (dX2 *= scale);
            this.focusY = this.centerY + (dY2 *= scale);
        }
        this.trivial = (float)Math.sqrt(this.radiusSq - dX2 * dX2);
        this.constA = this.a02 - this.centerX;
        this.constB = this.a12 - this.centerY;
        this.gDeltaDelta = 2.0f * (this.a00 * this.a00 + this.a10 * this.a10) / this.radiusSq;
    }

    @Override
    protected void fillRaster(int[] pixels, int off, int adjust, int x2, int y2, int w2, int h2) {
        if (this.isSimpleFocus && this.isNonCyclic && this.isSimpleLookup) {
            this.simpleNonCyclicFillRaster(pixels, off, adjust, x2, y2, w2, h2);
        } else {
            this.cyclicCircularGradientFillRaster(pixels, off, adjust, x2, y2, w2, h2);
        }
    }

    private void simpleNonCyclicFillRaster(int[] pixels, int off, int adjust, int x2, int y2, int w2, int h2) {
        float rowX = this.a00 * (float)x2 + this.a01 * (float)y2 + this.constA;
        float rowY = this.a10 * (float)x2 + this.a11 * (float)y2 + this.constB;
        float gDeltaDelta = this.gDeltaDelta;
        adjust += w2;
        int rgbclip = this.gradient[this.fastGradientArraySize];
        for (int j2 = 0; j2 < h2; ++j2) {
            int i2;
            float gRel = (rowX * rowX + rowY * rowY) / this.radiusSq;
            float gDelta = 2.0f * (this.a00 * rowX + this.a10 * rowY) / this.radiusSq + gDeltaDelta / 2.0f;
            for (i2 = 0; i2 < w2 && gRel >= 1.0f; ++i2) {
                pixels[off + i2] = rgbclip;
                gRel += gDelta;
                gDelta += gDeltaDelta;
            }
            while (i2 < w2 && gRel < 1.0f) {
                int gIndex;
                if (gRel <= 0.0f) {
                    gIndex = 0;
                } else {
                    float fIndex = gRel * 2048.0f;
                    int iIndex = (int)fIndex;
                    float s0 = sqrtLookup[iIndex];
                    float s1 = sqrtLookup[iIndex + 1] - s0;
                    fIndex = s0 + (fIndex - (float)iIndex) * s1;
                    gIndex = (int)(fIndex * (float)this.fastGradientArraySize);
                }
                pixels[off + i2] = this.gradient[gIndex];
                gRel += gDelta;
                gDelta += gDeltaDelta;
                ++i2;
            }
            while (i2 < w2) {
                pixels[off + i2] = rgbclip;
                ++i2;
            }
            off += adjust;
            rowX += this.a01;
            rowY += this.a11;
        }
    }

    private void cyclicCircularGradientFillRaster(int[] pixels, int off, int adjust, int x2, int y2, int w2, int h2) {
        double constC = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float constX = this.a00 * (float)x2 + this.a01 * (float)y2 + this.a02;
        float constY = this.a10 * (float)x2 + this.a11 * (float)y2 + this.a12;
        float precalc2 = 2.0f * this.centerY;
        float precalc3 = -2.0f * this.centerX;
        int indexer = off;
        int pixInc = w2 + adjust;
        for (int j2 = 0; j2 < h2; ++j2) {
            float X2 = this.a01 * (float)j2 + constX;
            float Y2 = this.a11 * (float)j2 + constY;
            for (int i2 = 0; i2 < w2; ++i2) {
                int colorAtPoint;
                double solutionY;
                double solutionX;
                if (X2 == this.focusX) {
                    solutionX = this.focusX;
                    solutionY = this.centerY;
                    solutionY += Y2 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    double slope = (Y2 - this.focusY) / (X2 - this.focusX);
                    double yIntercept = (double)Y2 - slope * (double)X2;
                    double A2 = slope * slope + 1.0;
                    double B2 = (double)precalc3 + -2.0 * slope * ((double)this.centerY - yIntercept);
                    double C2 = constC + yIntercept * (yIntercept - (double)precalc2);
                    float det = (float)Math.sqrt(B2 * B2 - 4.0 * A2 * C2);
                    solutionX = -B2;
                    solutionX += X2 < this.focusX ? (double)(-det) : (double)det;
                    solutionY = slope * (solutionX /= 2.0 * A2) + yIntercept;
                }
                float deltaXSq = X2 - this.focusX;
                deltaXSq *= deltaXSq;
                float deltaYSq = Y2 - this.focusY;
                deltaYSq *= deltaYSq;
                float currentToFocusSq = deltaXSq + deltaYSq;
                if (currentToFocusSq <= this.focusRadiusSq) {
                    colorAtPoint = this.indexIntoGradientsArrays(0.0f);
                } else {
                    float g2;
                    deltaXSq = (float)solutionX - this.focusX;
                    deltaXSq *= deltaXSq;
                    deltaYSq = (float)solutionY - this.focusY;
                    deltaYSq *= deltaYSq;
                    float intersectToFocusSq = deltaXSq + deltaYSq;
                    if (this.focusRadius > 0.0f) {
                        float currentToFocus = (float)Math.sqrt(currentToFocusSq);
                        float intersectToFocus = (float)Math.sqrt(intersectToFocusSq);
                        g2 = (currentToFocus - this.focusRadius) / (intersectToFocus - this.focusRadius);
                    } else {
                        g2 = (float)Math.sqrt(currentToFocusSq / intersectToFocusSq);
                    }
                    colorAtPoint = this.indexIntoGradientsArrays(g2);
                }
                pixels[indexer + i2] = colorAtPoint;
                X2 += this.a00;
                Y2 += this.a10;
            }
            indexer += pixInc;
        }
    }

    static {
        for (int i2 = 0; i2 < sqrtLookup.length; ++i2) {
            SVGRadialGradientPaintContext.sqrtLookup[i2] = (float)Math.sqrt((float)i2 / 2048.0f);
        }
    }
}

