/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api.coords;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.runelite.api.Client;
import net.runelite.api.Scene;
import net.runelite.api.WorldView;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;

public final class WorldPoint {
    private static final int[] REGION_MIRRORS = new int[]{12894, 8755, 12895, 8756, 13150, 9011, 13151, 9012};
    private final int x;
    private final int y;
    private final int plane;

    public WorldPoint dx(int dx2) {
        return new WorldPoint(this.x + dx2, this.y, this.plane);
    }

    public WorldPoint dy(int dy2) {
        return new WorldPoint(this.x, this.y + dy2, this.plane);
    }

    public WorldPoint dz(int dz2) {
        return new WorldPoint(this.x, this.y, this.plane + dz2);
    }

    public static boolean isInScene(Scene scene, int x2, int y2) {
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        int maxX = baseX + 104;
        int maxY = baseY + 104;
        return x2 >= baseX && x2 < maxX && y2 >= baseY && y2 < maxY;
    }

    @Deprecated
    public static boolean isInScene(Client client2, int x2, int y2) {
        return WorldPoint.isInScene(client2.getTopLevelWorldView(), x2, y2);
    }

    public static boolean isInScene(WorldView wv, int x2, int y2) {
        int baseX = wv.getBaseX();
        int baseY = wv.getBaseY();
        int maxX = baseX + wv.getSizeX();
        int maxY = baseY + wv.getSizeY();
        return x2 >= baseX && x2 < maxX && y2 >= baseY && y2 < maxY;
    }

    @Deprecated
    public boolean isInScene(Client client2) {
        return client2.getPlane() == this.plane && WorldPoint.isInScene(client2, this.x, this.y);
    }

    public static WorldPoint fromLocal(Client client2, LocalPoint local) {
        WorldView wv = client2.getWorldView(local.getWorldView());
        return WorldPoint.fromLocal(wv, local.getX(), local.getY(), wv.getPlane());
    }

    public static WorldPoint fromLocal(WorldView wv, int x2, int y2, int plane) {
        return new WorldPoint((x2 >> 7) + wv.getBaseX(), (y2 >> 7) + wv.getBaseY(), plane);
    }

    public static WorldPoint fromLocal(Scene scene, int x2, int y2, int plane) {
        return new WorldPoint((x2 >> 7) + scene.getBaseX(), (y2 >> 7) + scene.getBaseY(), plane);
    }

    @Deprecated
    public static WorldPoint fromLocal(Client client2, int x2, int y2, int plane) {
        return WorldPoint.fromLocal(client2.getTopLevelWorldView(), x2, y2, plane);
    }

    public static WorldPoint fromLocalInstance(Client client2, LocalPoint localPoint) {
        WorldView wv = client2.getWorldView(localPoint.getWorldView());
        return WorldPoint.fromLocalInstance(client2, localPoint, wv.getPlane());
    }

    public static WorldPoint fromLocalInstance(Client client2, LocalPoint localPoint, int plane) {
        WorldView wv = client2.getWorldView(localPoint.getWorldView());
        if (wv.isInstance()) {
            return WorldPoint.fromLocalInstance(wv.getInstanceTemplateChunks(), localPoint, plane);
        }
        return WorldPoint.fromLocal(client2, localPoint.getX(), localPoint.getY(), plane);
    }

    public static WorldPoint fromLocalInstance(Scene scene, LocalPoint localPoint, int plane) {
        if (scene.isInstance()) {
            return WorldPoint.fromLocalInstance(scene.getInstanceTemplateChunks(), localPoint, plane);
        }
        return WorldPoint.fromLocal(scene, localPoint.getX(), localPoint.getY(), plane);
    }

    private static WorldPoint fromLocalInstance(int[][][] instanceTemplateChunks, LocalPoint localPoint, int plane) {
        int sceneX = localPoint.getSceneX();
        int sceneY = localPoint.getSceneY();
        int chunkX = sceneX / 8;
        int chunkY = sceneY / 8;
        int templateChunk = instanceTemplateChunks[plane][chunkX][chunkY];
        int rotation = templateChunk >> 1 & 3;
        int templateChunkY = (templateChunk >> 3 & 0x7FF) * 8;
        int templateChunkX = (templateChunk >> 14 & 0x3FF) * 8;
        int templateChunkPlane = templateChunk >> 24 & 3;
        int x2 = templateChunkX + (sceneX & 7);
        int y2 = templateChunkY + (sceneY & 7);
        return WorldPoint.rotate(new WorldPoint(x2, y2, templateChunkPlane), 4 - rotation);
    }

    @Deprecated
    public static Collection<WorldPoint> toLocalInstance(Client client2, WorldPoint worldPoint) {
        return WorldPoint.toLocalInstance(client2.getTopLevelWorldView(), worldPoint);
    }

    public static Collection<WorldPoint> toLocalInstance(WorldView wv, WorldPoint worldPoint) {
        if (wv.isInstance()) {
            return WorldPoint.toLocalInstance(wv.getInstanceTemplateChunks(), wv.getBaseX(), wv.getBaseY(), worldPoint);
        }
        return Collections.singleton(worldPoint);
    }

    public static Collection<WorldPoint> toLocalInstance(Scene scene, WorldPoint worldPoint) {
        if (scene.isInstance()) {
            return WorldPoint.toLocalInstance(scene.getInstanceTemplateChunks(), scene.getBaseX(), scene.getBaseY(), worldPoint);
        }
        return Collections.singleton(worldPoint);
    }

    private static Collection<WorldPoint> toLocalInstance(int[][][] instanceTemplateChunks, int baseX, int baseY, WorldPoint worldPoint) {
        ArrayList<WorldPoint> worldPoints = new ArrayList<WorldPoint>();
        for (int z2 = 0; z2 < instanceTemplateChunks.length; ++z2) {
            for (int x2 = 0; x2 < instanceTemplateChunks[z2].length; ++x2) {
                for (int y2 = 0; y2 < instanceTemplateChunks[z2][x2].length; ++y2) {
                    int chunkData = instanceTemplateChunks[z2][x2][y2];
                    int rotation = chunkData >> 1 & 3;
                    int templateChunkY = (chunkData >> 3 & 0x7FF) * 8;
                    int templateChunkX = (chunkData >> 14 & 0x3FF) * 8;
                    int plane = chunkData >> 24 & 3;
                    if (worldPoint.getX() < templateChunkX || worldPoint.getX() >= templateChunkX + 8 || worldPoint.getY() < templateChunkY || worldPoint.getY() >= templateChunkY + 8 || plane != worldPoint.getPlane()) continue;
                    WorldPoint p2 = new WorldPoint(baseX + x2 * 8 + (worldPoint.getX() & 7), baseY + y2 * 8 + (worldPoint.getY() & 7), z2);
                    p2 = WorldPoint.rotate(p2, rotation);
                    worldPoints.add(p2);
                }
            }
        }
        return worldPoints;
    }

    private static WorldPoint rotate(WorldPoint point, int rotation) {
        int chunkX = point.getX() & 0xFFFFFFF8;
        int chunkY = point.getY() & 0xFFFFFFF8;
        int x2 = point.getX() & 7;
        int y2 = point.getY() & 7;
        switch (rotation) {
            case 1: {
                return new WorldPoint(chunkX + y2, chunkY + (7 - x2), point.getPlane());
            }
            case 2: {
                return new WorldPoint(chunkX + (7 - x2), chunkY + (7 - y2), point.getPlane());
            }
            case 3: {
                return new WorldPoint(chunkX + (7 - y2), chunkY + x2, point.getPlane());
            }
        }
        return point;
    }

    public int distanceTo(WorldArea other) {
        return this.toWorldArea().distanceTo(other);
    }

    public int distanceTo(WorldPoint other) {
        if (other.plane != this.plane) {
            return Integer.MAX_VALUE;
        }
        return this.distanceTo2D(other);
    }

    public int distanceTo2D(WorldPoint other) {
        return Math.max(Math.abs(this.getX() - other.getX()), Math.abs(this.getY() - other.getY()));
    }

    @Deprecated
    public static WorldPoint fromScene(Client client2, int x2, int y2, int plane) {
        return WorldPoint.fromScene(client2.getTopLevelWorldView(), x2, y2, plane);
    }

    public static WorldPoint fromScene(WorldView wv, int x2, int y2, int plane) {
        return new WorldPoint(x2 + wv.getBaseX(), y2 + wv.getBaseY(), plane);
    }

    public static WorldPoint fromScene(Scene scene, int x2, int y2, int plane) {
        return new WorldPoint(x2 + scene.getBaseX(), y2 + scene.getBaseY(), plane);
    }

    public int getRegionID() {
        return this.x >> 6 << 8 | this.y >> 6;
    }

    public static WorldPoint fromRegion(int regionId, int regionX, int regionY, int plane) {
        return new WorldPoint((regionId >>> 8 << 6) + regionX, ((regionId & 0xFF) << 6) + regionY, plane);
    }

    public int getRegionX() {
        return WorldPoint.getRegionOffset(this.x);
    }

    public int getRegionY() {
        return WorldPoint.getRegionOffset(this.y);
    }

    private static int getRegionOffset(int position) {
        return position & 0x3F;
    }

    public static WorldPoint getMirrorPoint(WorldPoint worldPoint, boolean toOverworld) {
        int region = worldPoint.getRegionID();
        for (int i2 = 0; i2 < REGION_MIRRORS.length; i2 += 2) {
            int real = REGION_MIRRORS[i2];
            int overworld = REGION_MIRRORS[i2 + 1];
            if (region != (toOverworld ? real : overworld)) continue;
            return WorldPoint.fromRegion(toOverworld ? overworld : real, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane());
        }
        return worldPoint;
    }

    public boolean isInArea(WorldArea ... worldAreas) {
        for (WorldArea area : worldAreas) {
            if (!area.contains(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isInArea2D(WorldArea ... worldAreas) {
        for (WorldArea area : worldAreas) {
            if (!area.contains2D(this)) continue;
            return true;
        }
        return false;
    }

    public WorldArea toWorldArea() {
        return new WorldArea(this, 1, 1);
    }

    public static WorldPoint fromCoord(int c2) {
        return new WorldPoint(c2 >>> 14 & 0x3FFF, c2 & 0x3FFF, c2 >>> 28 & 3);
    }

    public WorldPoint(int x2, int y2, int plane) {
        this.x = x2;
        this.y = y2;
        this.plane = plane;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getPlane() {
        return this.plane;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof WorldPoint)) {
            return false;
        }
        WorldPoint other = (WorldPoint)o2;
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getPlane() == other.getPlane();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getPlane();
        return result;
    }

    public String toString() {
        return "WorldPoint(x=" + this.getX() + ", y=" + this.getY() + ", plane=" + this.getPlane() + ")";
    }
}

