/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api.hooks;

import java.util.Set;
import net.runelite.api.GameObject;
import net.runelite.api.Model;
import net.runelite.api.Projection;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Texture;
import net.runelite.api.TileObject;
import net.runelite.api.WorldView;

public interface DrawCallbacks {
    public static final int GPU = 1;
    public static final int HILLSKEW = 2;
    public static final int NORMALS = 4;
    public static final int NO_VERTEX_SNAPPING = 8;
    public static final int ZBUF = 16;
    public static final int PASS_OPAQUE = 0;
    public static final int PASS_ALPHA = 1;

    default public void draw(Projection projection, Scene scene, Renderable renderable, int orientation, int x2, int y2, int z2, long hash) {
    }

    default public void drawScenePaint(Scene scene, SceneTilePaint paint, int plane, int tileX, int tileZ) {
    }

    default public void drawSceneTileModel(Scene scene, SceneTileModel model, int tileX, int tileZ) {
    }

    public void draw(int var1);

    default public void drawScene(double cameraX, double cameraY, double cameraZ, double cameraPitch, double cameraYaw, int plane) {
    }

    default public void postDrawScene() {
    }

    default public void animate(Texture texture, int diff) {
    }

    default public void loadScene(Scene scene) {
    }

    public void swapScene(Scene var1);

    default public boolean tileInFrustum(Scene scene, int pitchSin, int pitchCos, int yawSin, int yawCos, int cameraX, int cameraY, int cameraZ, int plane, int msx, int msy) {
        return true;
    }

    default public void loadScene(WorldView worldView, Scene scene) {
    }

    default public void despawnWorldView(WorldView worldView) {
    }

    default public void prepareSceneDraw(Scene scene, float cameraX, float cameraY, float cameraZ, float cameraPitch, float cameraYaw, int minLevel, int level, int maxLevel, Set<Integer> hideRoofIds) {
    }

    default public void drawPass(Projection entityProjection, Scene scene, int pass) {
    }

    default public void drawZone(Projection entityProjection, Scene scene, int pass, int zx, int zz) {
    }

    default public void drawDynamic(Projection worldProjection, Scene scene, TileObject tileObject, Renderable r2, Model m2, int orient, int x2, int y2, int z2) {
    }

    default public void drawTemp(Projection worldProjection, Scene scene, GameObject gameObject, Model m2) {
    }

    default public void invalidateZone(Scene scene, int zx, int zz) {
    }
}

