/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api.model;

import java.util.List;
import net.runelite.api.Point;
import net.runelite.api.geometry.SimplePolygon;

public class Jarvis {
    @Deprecated
    public static List<Point> convexHull(List<Point> points) {
        int[] xs = new int[points.size()];
        int[] ys = new int[xs.length];
        for (int i2 = 0; i2 < xs.length; ++i2) {
            Point p2 = points.get(i2);
            xs[i2] = p2.getX();
            ys[i2] = p2.getY();
        }
        SimplePolygon poly = Jarvis.convexHull(xs, ys);
        if (poly == null) {
            return null;
        }
        return poly.toRuneLitePointList();
    }

    public static SimplePolygon convexHull(int[] xs, int[] ys) {
        int next;
        int left;
        int i2;
        int length = xs.length;
        int offset = 0;
        for (i2 = 0; i2 < length; ++i2) {
            if (xs[i2] != Integer.MIN_VALUE) continue;
            ++offset;
            ++i2;
            break;
        }
        while (i2 < length) {
            if (xs[i2] == Integer.MIN_VALUE) {
                ++offset;
            } else {
                xs[i2 - offset] = xs[i2];
                ys[i2 - offset] = ys[i2];
            }
            ++i2;
        }
        if ((length -= offset) < 3) {
            return null;
        }
        int current = left = Jarvis.findLeftMost(xs, ys, length);
        SimplePolygon out = new SimplePolygon(new int[16], new int[16], 0);
        do {
            int cx2 = xs[current];
            int cy2 = ys[current];
            out.pushRight(cx2, cy2);
            if (out.size() > length) {
                return null;
            }
            next = 0;
            int nx = xs[next];
            int ny = ys[next];
            for (int i3 = 1; i3 < length; ++i3) {
                long cp2 = Jarvis.crossProduct(cx2, cy2, xs[i3], ys[i3], nx, ny);
                if (cp2 <= 0L && (cp2 != 0L || Jarvis.square(cx2 - xs[i3]) + Jarvis.square(cy2 - ys[i3]) <= Jarvis.square(cx2 - nx) + Jarvis.square(cy2 - ny))) continue;
                next = i3;
                nx = xs[next];
                ny = ys[next];
            }
        } while ((current = next) != left);
        return out;
    }

    private static int square(int x2) {
        return x2 * x2;
    }

    private static int findLeftMost(int[] xs, int[] ys, int length) {
        int idx = 0;
        int x2 = xs[idx];
        int y2 = ys[idx];
        for (int i2 = 1; i2 < length; ++i2) {
            int ix2 = xs[i2];
            if (ix2 >= x2 && (ix2 != x2 || ys[i2] >= y2)) continue;
            idx = i2;
            x2 = xs[idx];
            y2 = ys[idx];
        }
        return idx;
    }

    private static long crossProduct(int px, int py, int qx, int qy, int rx, int ry) {
        long val = (long)(qy - py) * (long)(rx - qx) - (long)(qx - px) * (long)(ry - qy);
        return val;
    }
}

