/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.callback;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BooleanSupplier;
import javax.inject.Singleton;
import net.runelite.api.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClientThread {
    private static final Logger log = LoggerFactory.getLogger(ClientThread.class);
    private final ConcurrentLinkedQueue<BooleanSupplier> invokes = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<BooleanSupplier> invokesAtTickEnd = new ConcurrentLinkedQueue();
    @Inject
    private Client client;

    public void invoke(Runnable r2) {
        this.invoke(() -> {
            r2.run();
            return true;
        });
    }

    public void invoke(BooleanSupplier r2) {
        if (this.client.isClientThread()) {
            if (!r2.getAsBoolean()) {
                this.invokes.add(r2);
            }
            return;
        }
        this.invokeLater(r2);
    }

    public void invokeLater(Runnable r2) {
        this.invokeLater(() -> {
            r2.run();
            return true;
        });
    }

    public void invokeLater(BooleanSupplier r2) {
        this.invokes.add(r2);
    }

    public void invokeAtTickEnd(Runnable r2) {
        this.invokesAtTickEnd.add(() -> {
            r2.run();
            return true;
        });
    }

    void invoke() {
        this.invokeList(this.invokes);
    }

    void invokeTickEnd() {
        this.invokeList(this.invokesAtTickEnd);
    }

    private void invokeList(ConcurrentLinkedQueue<BooleanSupplier> invokes) {
        assert (this.client.isClientThread());
        Iterator<BooleanSupplier> ir2 = invokes.iterator();
        while (ir2.hasNext()) {
            BooleanSupplier r2 = ir2.next();
            boolean remove = true;
            try {
                remove = r2.getAsBoolean();
            }
            catch (ThreadDeath d2) {
                throw d2;
            }
            catch (Throwable e2) {
                log.error("Exception in invoke", e2);
            }
            if (remove) {
                ir2.remove();
                continue;
            }
            log.trace("Deferring task {}", (Object)r2);
        }
    }
}

