/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.config;

import com.google.gson.Gson;
import com.google.inject.Inject;
import net.runelite.client.config.Notification;
import net.runelite.client.config.Serializer;

class NotificationSerializer
implements Serializer<Notification> {
    private final Gson gson;

    @Inject
    private NotificationSerializer(Gson gson) {
        this.gson = gson;
    }

    @Override
    public String serialize(Notification value) {
        return this.gson.toJson(value);
    }

    @Override
    public Notification deserialize(String s2) {
        if ("true".equals(s2) || "false".equals(s2)) {
            return new Notification().withEnabled(Boolean.parseBoolean(s2));
        }
        return this.gson.fromJson(s2, Notification.class);
    }
}

