/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.gpu;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

class GpuIntBuffer {
    private IntBuffer buffer = GpuIntBuffer.allocateDirect(65536);

    GpuIntBuffer() {
    }

    void put(float x2, float y2, float z2, int w2) {
        this.buffer.put(Float.floatToIntBits(x2)).put(Float.floatToIntBits(y2)).put(Float.floatToIntBits(z2)).put(w2);
    }

    void flip() {
        this.buffer.flip();
    }

    void clear() {
        this.buffer.clear();
    }

    void ensureCapacity(int size) {
        int position;
        int capacity = this.buffer.capacity();
        if (capacity - (position = this.buffer.position()) < size) {
            while ((capacity *= 2) - position < size) {
            }
            IntBuffer newB = GpuIntBuffer.allocateDirect(capacity);
            this.buffer.flip();
            newB.put(this.buffer);
            this.buffer = newB;
        }
    }

    IntBuffer getBuffer() {
        return this.buffer;
    }

    static IntBuffer allocateDirect(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }
}

