/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemstats;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.game.ItemEquipmentStats;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStats;
import net.runelite.client.plugins.itemstats.Effect;
import net.runelite.client.plugins.itemstats.ItemStatChanges;
import net.runelite.client.plugins.itemstats.ItemStatConfig;
import net.runelite.client.plugins.itemstats.Positivity;
import net.runelite.client.plugins.itemstats.StatChange;
import net.runelite.client.plugins.itemstats.StatsChanges;
import net.runelite.client.plugins.itemstats.potions.PotionDuration;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.QuantityFormatter;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ItemStatOverlay
extends Overlay {
    @VisibleForTesting
    static final ItemStats UNARMED = new ItemStats(true, 0.0, 0, ItemEquipmentStats.builder().aspeed(4).build());
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private ItemStatChanges statChanges;
    @Inject
    private ItemStatConfig config;

    @Override
    public Dimension render(Graphics2D graphics) {
        String tooltip;
        ItemStats stats;
        if (this.client.isMenuOpen() || !this.config.relative() && !this.config.absolute() && !this.config.theoretical()) {
            return null;
        }
        MenuEntry[] menu = this.client.getMenuEntries();
        int menuSize = menu.length;
        if (menuSize <= 0) {
            return null;
        }
        MenuEntry entry = menu[menuSize - 1];
        Widget widget = entry.getWidget();
        if (widget == null) {
            return null;
        }
        int group = WidgetUtil.componentToInterface(widget.getId());
        int itemId = -1;
        if (group == 387 || group == 12 && widget.getParentId() == 983044) {
            Widget widgetItem = widget.getChild(1);
            if (widgetItem != null) {
                itemId = widgetItem.getItemId();
            }
        } else if (widget.getId() == 0x950000 || group == 85 || widget.getId() == 786445 && this.config.showStatsInBank() || group == 15 && this.config.showStatsInBank() || widget.getId() == 47448074 && this.config.showStatsInBank() || group == 725 && this.config.showStatsInBank()) {
            itemId = widget.getItemId();
        }
        if (itemId == -1) {
            return null;
        }
        if (this.config.consumableStats()) {
            PotionDuration p2;
            Effect change = this.statChanges.get(itemId);
            if (change != null) {
                StringBuilder b2 = new StringBuilder();
                StatsChanges statsChanges = change.calculate(this.client);
                for (StatChange c2 : statsChanges.getStatChanges()) {
                    b2.append(this.buildStatChangeString(c2));
                }
                String tooltip2 = b2.toString();
                if (!tooltip2.isEmpty()) {
                    this.tooltipManager.add(new Tooltip(tooltip2));
                }
            }
            if ((p2 = PotionDuration.get(itemId)) != null) {
                PotionDuration.PotionDurationRange[] durationRanges = p2.getDurationRanges();
                StringBuilder sb = new StringBuilder();
                if (durationRanges.length == 1) {
                    Duration duration = durationRanges[0].getLowestDuration();
                    sb.append("Duration: ").append(DurationFormatUtils.formatDuration(duration.toMillis(), "m:ss"));
                } else {
                    for (PotionDuration.PotionDurationRange durationRange : durationRanges) {
                        if (sb.length() > 0) {
                            sb.append("</br>");
                        }
                        sb.append(durationRange.getPotionName()).append(": ");
                        Duration lowestDuration = durationRange.getLowestDuration();
                        sb.append(DurationFormatUtils.formatDuration(lowestDuration.toMillis(), "m:ss"));
                        Duration highestDuration = durationRange.getHighestDuration();
                        if (lowestDuration == highestDuration) continue;
                        sb.append('~');
                        sb.append(DurationFormatUtils.formatDuration(highestDuration.toMillis(), "m:ss"));
                    }
                }
                this.tooltipManager.add(new Tooltip(sb.toString()));
            }
        }
        if (this.config.equipmentStats() && (stats = this.itemManager.getItemStats(itemId)) != null && !(tooltip = this.buildStatBonusString(stats)).isEmpty()) {
            this.tooltipManager.add(new Tooltip(tooltip));
        }
        return null;
    }

    private String getChangeString(double value, boolean inverse, boolean showPercent) {
        Color plus = Positivity.getColor(this.config, Positivity.BETTER_UNCAPPED);
        Color minus = Positivity.getColor(this.config, Positivity.WORSE);
        if (value == 0.0) {
            return "";
        }
        Color color = inverse ? (value > 0.0 ? minus : plus) : (value > 0.0 ? plus : minus);
        String prefix = value > 0.0 ? "+" : "";
        String suffix = showPercent ? "%" : "";
        String valueString = QuantityFormatter.formatNumber(value);
        return ColorUtil.wrapWithColorTag(prefix + valueString + suffix, color);
    }

    private String buildStatRow(String label, double value, double diffValue, boolean inverse, boolean showPercent) {
        return this.buildStatRow(label, value, diffValue, inverse, showPercent, true);
    }

    private String buildStatRow(String label, double value, double diffValue, boolean inverse, boolean showPercent, boolean showBase) {
        StringBuilder b2 = new StringBuilder();
        if (value != 0.0 || diffValue != 0.0) {
            String changeStr = this.getChangeString(diffValue, inverse, showPercent);
            if (this.config.alwaysShowBaseStats() && showBase) {
                String valueStr = QuantityFormatter.formatNumber(value);
                b2.append(label).append(": ").append(valueStr).append((String)(!changeStr.isEmpty() ? " (" + changeStr + ") " : "")).append("</br>");
            } else if (!changeStr.isEmpty()) {
                b2.append(label).append(": ").append(changeStr).append("</br>");
            }
        }
        return b2.toString();
    }

    private ItemStats getItemStatsFromContainer(ItemContainer container, int slotID) {
        Item item = container.getItem(slotID);
        return item != null ? this.itemManager.getItemStats(item.getId()) : null;
    }

    @VisibleForTesting
    String buildStatBonusString(ItemStats s2) {
        ItemStats other = null;
        ItemStats offHand = null;
        ItemEquipmentStats currentEquipment = s2.getEquipment();
        ItemContainer c2 = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (s2.isEquipable() && currentEquipment != null && c2 != null) {
            ItemEquipmentStats otherEquip;
            int slot = currentEquipment.getSlot();
            other = this.getItemStatsFromContainer(c2, slot);
            if (other == null && slot == EquipmentInventorySlot.SHIELD.getSlotIdx() && (other = this.getItemStatsFromContainer(c2, EquipmentInventorySlot.WEAPON.getSlotIdx())) != null && (otherEquip = other.getEquipment()) != null) {
                ItemStats itemStats = other = otherEquip.isTwoHanded() ? ItemStatOverlay.subtract(other, UNARMED) : null;
            }
            if (slot == EquipmentInventorySlot.WEAPON.getSlotIdx()) {
                if (other == null) {
                    other = UNARMED;
                }
                if (currentEquipment.isTwoHanded()) {
                    offHand = this.getItemStatsFromContainer(c2, EquipmentInventorySlot.SHIELD.getSlotIdx());
                }
            }
        }
        ItemStats subtracted = ItemStatOverlay.subtract(ItemStatOverlay.subtract(s2, other), offHand);
        ItemEquipmentStats e2 = subtracted.getEquipment();
        StringBuilder b2 = new StringBuilder();
        if (this.config.showWeight()) {
            double sw = this.config.alwaysShowBaseStats() ? subtracted.getWeight() : s2.getWeight();
            b2.append(this.buildStatRow("Weight", s2.getWeight(), sw, true, false, s2.isEquipable()));
        }
        if (subtracted.isEquipable() && e2 != null) {
            b2.append(this.buildStatRow("Prayer", currentEquipment.getPrayer(), e2.getPrayer(), false, false));
            b2.append(this.buildStatRow("Speed", currentEquipment.getAspeed(), e2.getAspeed(), true, false));
            b2.append(this.buildStatRow("Melee Str", currentEquipment.getStr(), e2.getStr(), false, false));
            b2.append(this.buildStatRow("Range Str", currentEquipment.getRstr(), e2.getRstr(), false, false));
            b2.append(this.buildStatRow("Magic Dmg", currentEquipment.getMdmg(), e2.getMdmg(), false, true));
            StringBuilder abb = new StringBuilder();
            abb.append(this.buildStatRow("Stab", currentEquipment.getAstab(), e2.getAstab(), false, false));
            abb.append(this.buildStatRow("Slash", currentEquipment.getAslash(), e2.getAslash(), false, false));
            abb.append(this.buildStatRow("Crush", currentEquipment.getAcrush(), e2.getAcrush(), false, false));
            abb.append(this.buildStatRow("Magic", currentEquipment.getAmagic(), e2.getAmagic(), false, false));
            abb.append(this.buildStatRow("Range", currentEquipment.getArange(), e2.getArange(), false, false));
            if (abb.length() > 0) {
                b2.append(ColorUtil.wrapWithColorTag("Attack Bonus</br>", JagexColors.MENU_TARGET)).append((CharSequence)abb);
            }
            StringBuilder dbb = new StringBuilder();
            dbb.append(this.buildStatRow("Stab", currentEquipment.getDstab(), e2.getDstab(), false, false));
            dbb.append(this.buildStatRow("Slash", currentEquipment.getDslash(), e2.getDslash(), false, false));
            dbb.append(this.buildStatRow("Crush", currentEquipment.getDcrush(), e2.getDcrush(), false, false));
            dbb.append(this.buildStatRow("Magic", currentEquipment.getDmagic(), e2.getDmagic(), false, false));
            dbb.append(this.buildStatRow("Range", currentEquipment.getDrange(), e2.getDrange(), false, false));
            if (dbb.length() > 0) {
                b2.append(ColorUtil.wrapWithColorTag("Defence Bonus</br>", JagexColors.MENU_TARGET)).append((CharSequence)dbb);
            }
        }
        return b2.toString();
    }

    private static ItemStats subtract(ItemStats one, ItemStats two) {
        ItemEquipmentStats newEquipment;
        if (two == null) {
            return one;
        }
        double newWeight = one.getWeight() - two.getWeight();
        if (two.getEquipment() != null) {
            ItemEquipmentStats equipment = one.getEquipment() != null ? one.getEquipment() : ItemEquipmentStats.builder().build();
            newEquipment = ItemEquipmentStats.builder().slot(equipment.getSlot()).astab(equipment.getAstab() - two.getEquipment().getAstab()).aslash(equipment.getAslash() - two.getEquipment().getAslash()).acrush(equipment.getAcrush() - two.getEquipment().getAcrush()).amagic(equipment.getAmagic() - two.getEquipment().getAmagic()).arange(equipment.getArange() - two.getEquipment().getArange()).dstab(equipment.getDstab() - two.getEquipment().getDstab()).dslash(equipment.getDslash() - two.getEquipment().getDslash()).dcrush(equipment.getDcrush() - two.getEquipment().getDcrush()).dmagic(equipment.getDmagic() - two.getEquipment().getDmagic()).drange(equipment.getDrange() - two.getEquipment().getDrange()).str(equipment.getStr() - two.getEquipment().getStr()).rstr(equipment.getRstr() - two.getEquipment().getRstr()).mdmg(equipment.getMdmg() - two.getEquipment().getMdmg()).prayer(equipment.getPrayer() - two.getEquipment().getPrayer()).aspeed(equipment.getAspeed() - two.getEquipment().getAspeed()).build();
        } else {
            newEquipment = one.getEquipment();
        }
        return new ItemStats(one.isEquipable(), newWeight, 0, newEquipment);
    }

    private String buildStatChangeString(StatChange c2) {
        StringBuilder b2 = new StringBuilder();
        b2.append(ColorUtil.colorTag(Positivity.getColor(this.config, c2.getPositivity())));
        if (this.config.relative()) {
            b2.append(c2.getFormattedRelative());
        }
        if (this.config.theoretical()) {
            if (this.config.relative()) {
                b2.append('/');
            }
            b2.append(c2.getFormattedTheoretical());
        }
        if (this.config.absolute() && (this.config.relative() || this.config.theoretical())) {
            b2.append(" (");
        }
        if (this.config.absolute()) {
            b2.append(c2.getAbsolute());
        }
        if (this.config.absolute() && (this.config.relative() || this.config.theoretical())) {
            b2.append(')');
        }
        b2.append(' ').append(c2.getStat().getName());
        b2.append("</br>");
        return b2.toString();
    }
}

