/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.kourendlibrary;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.kourendlibrary.Book;

class Bookcase {
    private final WorldPoint location;
    private final List<Integer> index;
    private boolean isBookSet;
    private Book book;
    private final Set<Book> possibleBooks = new HashSet<Book>();

    Bookcase(WorldPoint location) {
        this.location = location;
        this.index = new ArrayList<Integer>();
    }

    void clearBook() {
        this.book = null;
        this.isBookSet = false;
    }

    void setBook(Book book) {
        this.book = book;
        this.isBookSet = true;
    }

    String getLocationString() {
        boolean west;
        StringBuilder b2 = new StringBuilder();
        boolean north = this.location.getY() > 3815;
        boolean bl2 = west = this.location.getX() < 1625;
        if (this.location.getPlane() == 0) {
            north = this.location.getY() > 3813;
            boolean bl3 = west = this.location.getX() < 1627;
        }
        if (north && west) {
            b2.append("Northwest");
        } else if (north) {
            b2.append("Northeast");
        } else if (west) {
            b2.append("Southwest");
        } else {
            b2.append("Center");
        }
        b2.append(' ');
        switch (this.location.getPlane()) {
            case 0: {
                b2.append("ground floor");
                break;
            }
            case 1: {
                b2.append("middle floor");
                break;
            }
            case 2: {
                b2.append("top floor");
            }
        }
        return b2.toString();
    }

    public WorldPoint getLocation() {
        return this.location;
    }

    public List<Integer> getIndex() {
        return this.index;
    }

    public boolean isBookSet() {
        return this.isBookSet;
    }

    public Book getBook() {
        return this.book;
    }

    public Set<Book> getPossibleBooks() {
        return this.possibleBooks;
    }
}

