/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.loottracker;

import java.time.Instant;
import java.util.Arrays;
import net.runelite.http.api.loottracker.LootRecordType;

class ConfigLoot {
    LootRecordType type;
    String name;
    int kills;
    Instant first = Instant.now();
    Instant last;
    int[] drops;

    ConfigLoot(LootRecordType type, String name) {
        this.type = type;
        this.name = name;
        this.drops = new int[0];
    }

    void add(int id2, int qty) {
        for (int i2 = 0; i2 < this.drops.length; i2 += 2) {
            if (this.drops[i2] != id2) continue;
            int n2 = i2 + 1;
            this.drops[n2] = this.drops[n2] + qty;
            return;
        }
        this.drops = Arrays.copyOf(this.drops, this.drops.length + 2);
        this.drops[this.drops.length - 2] = id2;
        this.drops[this.drops.length - 1] = qty;
    }

    int numDrops() {
        return this.drops.length / 2;
    }

    public LootRecordType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getKills() {
        return this.kills;
    }

    public Instant getFirst() {
        return this.first;
    }

    public Instant getLast() {
        return this.last;
    }

    public int[] getDrops() {
        return this.drops;
    }

    public void setType(LootRecordType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKills(int kills) {
        this.kills = kills;
    }

    public void setFirst(Instant first) {
        this.first = first;
    }

    public void setLast(Instant last) {
        this.last = last;
    }

    public void setDrops(int[] drops) {
        this.drops = drops;
    }

    public String toString() {
        return "ConfigLoot(type=" + String.valueOf((Object)this.getType()) + ", name=" + this.getName() + ", kills=" + this.getKills() + ", first=" + String.valueOf(this.getFirst()) + ", last=" + String.valueOf(this.getLast()) + ", drops=" + Arrays.toString(this.getDrops()) + ")";
    }

    public ConfigLoot() {
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ConfigLoot)) {
            return false;
        }
        ConfigLoot other = (ConfigLoot)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        LootRecordType this$type = this.getType();
        LootRecordType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigLoot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LootRecordType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

