/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.puzzlesolver.solver.pathfinding;

import java.util.ArrayList;
import java.util.List;
import net.runelite.client.plugins.puzzlesolver.solver.PuzzleState;
import net.runelite.client.plugins.puzzlesolver.solver.heuristics.Heuristic;
import net.runelite.client.plugins.puzzlesolver.solver.pathfinding.Pathfinder;

public class IDAStar
extends Pathfinder {
    public IDAStar(Heuristic heuristic) {
        super(heuristic);
    }

    @Override
    public List<PuzzleState> computePath(PuzzleState root) {
        PuzzleState goalNode = this.path(root);
        ArrayList<PuzzleState> path = new ArrayList<PuzzleState>();
        for (PuzzleState parent = goalNode; parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        return path;
    }

    private PuzzleState path(PuzzleState root) {
        int bound = root.getHeuristicValue(this.getHeuristic());
        PuzzleState t2;
        while ((t2 = this.search(root, 0, bound)) == null) {
            ++bound;
        }
        return t2;
    }

    private PuzzleState search(PuzzleState node, int g2, int bound) {
        int h2 = node.getHeuristicValue(this.getHeuristic());
        int f2 = g2 + h2;
        if (f2 > bound) {
            return null;
        }
        if (h2 == 0) {
            return node;
        }
        for (PuzzleState successor : node.computeMoves()) {
            PuzzleState t2 = this.search(successor, g2 + 1, bound);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }
}

