/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.roofremoval;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.PreMapLoad;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.roofremoval.RoofRemovalConfig;
import net.runelite.client.plugins.roofremoval.RoofRemovalConfigOverride;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Roof Removal", description="Remove only the needed roofs above your player, hovered tile, or destination", enabledByDefault=false)
public class RoofRemovalPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RoofRemovalPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Gson gson;
    @Inject
    private RoofRemovalConfig config;
    private final Map<Integer, long[]> overrides = new HashMap<Integer, long[]>();
    private final Set<Integer> configOverrideRegions = new HashSet<Integer>();

    @Provides
    RoofRemovalConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(RoofRemovalConfig.class);
    }

    @Override
    public void startUp() throws IOException {
        this.buildConfigOverrides();
        this.loadRoofOverrides();
        this.clientThread.invoke(() -> {
            Scene scene = this.client.getScene();
            if (scene == null) {
                return false;
            }
            scene.setRoofRemovalMode(this.buildRoofRemovalFlags());
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
            return true;
        });
    }

    @Override
    public void shutDown() {
        this.overrides.clear();
        this.clientThread.invoke(() -> {
            this.client.getScene().setRoofRemovalMode(0);
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
        });
    }

    @Subscribe
    public void onPreMapLoad(PreMapLoad preMapLoad) {
        this.performRoofRemoval(preMapLoad.getScene());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e2) {
        if (!e2.getGroup().equals("roofremoval")) {
            return;
        }
        if (e2.getKey().startsWith("remove")) {
            this.client.getScene().setRoofRemovalMode(this.buildRoofRemovalFlags());
        } else if (e2.getKey().startsWith("override")) {
            this.buildConfigOverrides();
            this.clientThread.invoke(() -> {
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    this.client.setGameState(GameState.LOADING);
                }
            });
        }
    }

    private int buildRoofRemovalFlags() {
        int roofRemovalMode = 0;
        if (this.config.removePosition()) {
            roofRemovalMode |= 1;
        }
        if (this.config.removeHovered()) {
            roofRemovalMode |= 2;
        }
        if (this.config.removeDestination()) {
            roofRemovalMode |= 4;
        }
        if (this.config.removeBetween()) {
            roofRemovalMode |= 8;
        }
        return roofRemovalMode;
    }

    private void buildConfigOverrides() {
        this.configOverrideRegions.clear();
        for (RoofRemovalConfigOverride configOverride : RoofRemovalConfigOverride.values()) {
            if (!configOverride.getEnabled().test(this.config)) continue;
            this.configOverrideRegions.addAll(configOverride.getRegions());
        }
    }

    private void performRoofRemoval(Scene scene) {
        this.applyRoofOverrides(scene);
        Stopwatch sw = Stopwatch.createStarted();
        scene.buildRoofs();
        log.debug("Roof building duration: {}", (Object)sw.stop());
    }

    private void loadRoofOverrides() throws IOException {
        try (InputStream in2 = this.getClass().getResourceAsStream("overrides.jsonc");){
            InputStreamReader data = new InputStreamReader(in2, StandardCharsets.UTF_8);
            Type type = new TypeToken<Map<Integer, List<FlaggedArea>>>(){}.getType();
            Map parsed = (Map)this.gson.fromJson((Reader)data, type);
            this.overrides.clear();
            for (Map.Entry entry : parsed.entrySet()) {
                for (FlaggedArea fla : (List)entry.getValue()) {
                    for (int z2 = fla.z1; z2 <= fla.z2; ++z2) {
                        int packedRegion = (Integer)entry.getKey() << 2 | z2;
                        long[] regionData = this.overrides.computeIfAbsent(packedRegion, k2 -> new long[64]);
                        for (int y2 = fla.ry1; y2 <= fla.ry2; ++y2) {
                            long row = regionData[y2];
                            for (int x2 = fla.rx1; x2 <= fla.rx2; ++x2) {
                                row |= 1L << x2;
                            }
                            regionData[y2] = row;
                        }
                    }
                }
            }
        }
    }

    private void applyRoofOverrides(Scene scene) {
        Stopwatch sw = Stopwatch.createStarted();
        boolean regionsHaveOverrides = false;
        block0: for (int regionID : scene.getMapRegions()) {
            if (this.configOverrideRegions.contains(regionID)) {
                regionsHaveOverrides = true;
                break;
            }
            for (int z2 = 0; z2 < 4; ++z2) {
                if (!this.overrides.containsKey(regionID << 2 | z2)) continue;
                regionsHaveOverrides = true;
                break block0;
            }
        }
        if (!regionsHaveOverrides) {
            return;
        }
        Tile[][][] tiles = scene.getTiles();
        byte[][][] settings = scene.getExtendedTileSettings();
        int SCENE_OFFSET = 40;
        for (int z3 = 0; z3 < 4; ++z3) {
            for (int x2 = 0; x2 < 104; ++x2) {
                for (int y2 = 0; y2 < 104; ++y2) {
                    Tile tile = tiles[z3][x2][y2];
                    if (tile == null) continue;
                    WorldPoint wp = WorldPoint.fromLocalInstance(scene, tile.getLocalLocation(), tile.getPlane());
                    int regionAndPlane = wp.getRegionID() << 2 | wp.getPlane();
                    if (this.configOverrideRegions.contains(wp.getRegionID())) {
                        byte[] byArray = settings[z3][x2 + 40];
                        int n2 = y2 + 40;
                        byArray[n2] = (byte)(byArray[n2] | 4);
                        continue;
                    }
                    if (!this.overrides.containsKey(regionAndPlane)) continue;
                    int rx = wp.getRegionX();
                    int ry = wp.getRegionY();
                    long[] region = this.overrides.get(regionAndPlane);
                    if ((region[ry] & 1L << rx) == 0L) continue;
                    byte[] byArray = settings[z3][x2 + 40];
                    int n3 = y2 + 40;
                    byArray[n3] = (byte)(byArray[n3] | 4);
                }
            }
        }
        log.debug("Roof override duration: {}", (Object)sw.stop());
    }

    private static class FlaggedArea {
        int rx1;
        int ry1;
        int rx2;
        int ry2;
        int z1;
        int z2;

        private FlaggedArea() {
        }
    }
}

