/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.stretchedmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.input.MouseListener;

public class TranslateMouseListener
implements MouseListener {
    private final Client client;

    @Inject
    public TranslateMouseListener(Client client2) {
        this.client = client2;
    }

    @Override
    public MouseEvent mouseClicked(MouseEvent mouseEvent) {
        return this.translateEvent(mouseEvent);
    }

    @Override
    public MouseEvent mousePressed(MouseEvent mouseEvent) {
        return this.translateEvent(mouseEvent);
    }

    @Override
    public MouseEvent mouseReleased(MouseEvent mouseEvent) {
        return this.translateEvent(mouseEvent);
    }

    @Override
    public MouseEvent mouseEntered(MouseEvent mouseEvent) {
        return this.translateEvent(mouseEvent);
    }

    @Override
    public MouseEvent mouseExited(MouseEvent mouseEvent) {
        return this.translateEvent(mouseEvent);
    }

    @Override
    public MouseEvent mouseDragged(MouseEvent mouseEvent) {
        return this.translateEvent(mouseEvent);
    }

    @Override
    public MouseEvent mouseMoved(MouseEvent mouseEvent) {
        return this.translateEvent(mouseEvent);
    }

    private MouseEvent translateEvent(MouseEvent e2) {
        Dimension stretchedDimensions = this.client.getStretchedDimensions();
        Dimension realDimensions = this.client.getRealDimensions();
        int newX = (int)((double)e2.getX() / ((double)stretchedDimensions.width / realDimensions.getWidth()));
        int newY = (int)((double)e2.getY() / ((double)stretchedDimensions.height / realDimensions.getHeight()));
        MouseEvent mouseEvent = new MouseEvent((Component)e2.getSource(), e2.getID(), e2.getWhen(), e2.getModifiersEx(), newX, newY, e2.getClickCount(), e2.isPopupTrigger(), e2.getButton());
        if (e2.isConsumed()) {
            mouseEvent.consume();
        }
        return mouseEvent;
    }
}

