/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import java.awt.CardLayout;
import java.awt.Component;
import net.runelite.client.ui.PluginPanel;

public class MultiplexingPluginPanel
extends PluginPanel {
    private final CardLayout layout = new CardLayout();
    private boolean active = false;
    private PluginPanel current;

    public MultiplexingPluginPanel(PluginPanel root) {
        super(false);
        this.setLayout(this.layout);
        this.pushState(root);
    }

    public void destroy() {
        for (int i2 = this.getComponentCount() - 1; i2 > 0; --i2) {
            this.onRemove((PluginPanel)this.getComponent(i2));
            this.remove(i2);
        }
    }

    public void pushState(PluginPanel subpanel) {
        int index = -1;
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            if (this.getComponent(i2) != subpanel) continue;
            index = i2;
            break;
        }
        if (this.active) {
            this.current.onDeactivate();
            subpanel.onActivate();
        }
        this.current = subpanel;
        String name = "" + System.identityHashCode(subpanel);
        if (index != -1) {
            for (int i3 = this.getComponentCount() - 1; i3 > index; --i3) {
                this.popState();
            }
        } else {
            this.add((Component)subpanel, name);
            this.onAdd(subpanel);
        }
        this.layout.show(this, name);
        this.revalidate();
    }

    public void popState() {
        int count = this.getComponentCount();
        if (count <= 1) {
            assert (false) : "Cannot pop last component";
            return;
        }
        PluginPanel subpanel = (PluginPanel)this.getComponent(count - 2);
        if (this.active) {
            this.current.onDeactivate();
            subpanel.onActivate();
            this.current = subpanel;
        }
        this.layout.show(this, "" + System.identityHashCode(subpanel));
        this.onRemove((PluginPanel)this.getComponent(count - 1));
        this.remove(count - 1);
        this.revalidate();
    }

    protected void onAdd(PluginPanel p2) {
    }

    protected void onRemove(PluginPanel p2) {
    }

    @Override
    public void onActivate() {
        this.active = true;
        this.current.onActivate();
    }

    @Override
    public void onDeactivate() {
        this.active = false;
        this.current.onDeactivate();
    }
}

