/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableExceptionLogger<V>
implements Callable<V> {
    private static final Logger log = LoggerFactory.getLogger(CallableExceptionLogger.class);
    private final Callable<V> callable;

    @Override
    public V call() throws Exception {
        try {
            return this.callable.call();
        }
        catch (Throwable ex2) {
            log.error("Uncaught exception in callable {}", (Object)this.callable, (Object)ex2);
            throw ex2;
        }
    }

    public static <V> CallableExceptionLogger<V> wrap(Callable<V> callable) {
        return new CallableExceptionLogger<V>(callable);
    }

    public CallableExceptionLogger(Callable<V> callable) {
        this.callable = callable;
    }
}

