/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import com.google.common.primitives.Ints;
import java.awt.Color;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ColorUtil {
    public static final int MAX_RGB_VALUE = 255;
    public static final int MIN_RGB_VALUE = 0;
    private static final String OPENING_COLOR_TAG_START = "<col=";
    private static final String OPENING_COLOR_TAG_END = ">";
    public static final String CLOSING_COLOR_TAG = "</col>";
    private static final Pattern ALPHA_HEX_PATTERN = Pattern.compile("^(#|0x)?[0-9a-fA-F]{7,8}");
    private static final Pattern HEX_PATTERN = Pattern.compile("^(#|0x)?[0-9a-fA-F]{1,8}");

    public static String colorTag(Color color) {
        return OPENING_COLOR_TAG_START + ColorUtil.colorToHexCode(color) + OPENING_COLOR_TAG_END;
    }

    public static String prependColorTag(String str, Color color) {
        return ColorUtil.colorTag(color) + str;
    }

    public static String wrapWithColorTag(String str, Color color) {
        return ColorUtil.prependColorTag(str, color) + CLOSING_COLOR_TAG;
    }

    public static String toHexColor(Color color) {
        return "#" + ColorUtil.colorToHexCode(color);
    }

    public static Color colorLerp(Color a2, Color b2, double t2) {
        double r1 = a2.getRed();
        double r2 = b2.getRed();
        double g1 = a2.getGreen();
        double g2 = b2.getGreen();
        double b1 = a2.getBlue();
        double b22 = b2.getBlue();
        double a1 = a2.getAlpha();
        double a22 = b2.getAlpha();
        return new Color((int)Math.round(r1 + t2 * (r2 - r1)), (int)Math.round(g1 + t2 * (g2 - g1)), (int)Math.round(b1 + t2 * (b22 - b1)), (int)Math.round(a1 + t2 * (a22 - a1)));
    }

    public static String colorToHexCode(Color color) {
        return String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    public static String colorToAlphaHexCode(Color color) {
        return String.format("%08x", color.getRGB());
    }

    public static Color colorWithAlpha(Color color, int alpha) {
        if (color.getAlpha() == alpha) {
            return color;
        }
        alpha = ColorUtil.constrainValue(alpha);
        return new Color(color.getRGB() & 0xFFFFFF | alpha << 24, true);
    }

    public static boolean isAlphaHex(String hex) {
        return ALPHA_HEX_PATTERN.matcher(hex).matches();
    }

    public static boolean isHex(String hex) {
        return HEX_PATTERN.matcher(hex).matches();
    }

    public static int constrainValue(int value) {
        return Ints.constrainToRange(value, 0, 255);
    }

    public static Color fromString(String string) {
        try {
            int i2 = Integer.decode(string);
            return new Color(i2, true);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public static Color fromHex(String hex) {
        if (!((String)hex).startsWith("#") && !((String)hex).startsWith("0x")) {
            hex = "#" + (String)hex;
        }
        if (((String)hex).length() <= 7 && ((String)hex).startsWith("#") || ((String)hex).length() <= 8 && ((String)hex).startsWith("0x")) {
            try {
                return Color.decode((String)hex);
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
        try {
            return new Color(Long.decode((String)hex).intValue(), true);
        }
        catch (NumberFormatException e3) {
            return null;
        }
    }

    public static Color fromObject(@Nonnull Object object) {
        int i2 = object.hashCode();
        float h2 = (float)(i2 % 360) / 360.0f;
        return Color.getHSBColor(h2, 1.0f, 1.0f);
    }
}

