/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public class IllegalReflectionExclusion
implements ExclusionStrategy {
    private static final Set<ClassLoader> PRIVATE_CLASSLOADERS = new HashSet<ClassLoader>();

    @Override
    public boolean shouldSkipField(FieldAttributes f2) {
        if (!PRIVATE_CLASSLOADERS.contains(f2.getDeclaringClass().getClassLoader())) {
            return false;
        }
        assert (!Modifier.isPrivate(f2.getDeclaringClass().getModifiers())) : "gsoning private class " + f2.getDeclaringClass().getName();
        try {
            f2.getDeclaringClass().getField(f2.getName());
        }
        catch (NoSuchFieldException e2) {
            throw new AssertionError((Object)("gsoning private field " + f2.getDeclaringClass() + "." + f2.getName()));
        }
        return false;
    }

    @Override
    public boolean shouldSkipClass(Class<?> clazz) {
        return false;
    }

    static {
        for (ClassLoader cl2 = ClassLoader.getSystemClassLoader(); cl2 != null; cl2 = cl2.getParent()) {
            PRIVATE_CLASSLOADERS.add(cl2);
        }
    }
}

