/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.TaskTagParser;

public class ErrorStrip
extends JPanel {
    private RSyntaxTextArea textArea;
    private transient Listener listener;
    private boolean showMarkedOccurrences;
    private boolean showMarkAll;
    private Map<Color, Color> brighterColors;
    private ParserNotice.Level levelThreshold;
    private boolean followCaret;
    private Color caretMarkerColor;
    private int caretLineY;
    private int lastLineY;
    private transient ErrorStripMarkerToolTipProvider markerToolTipProvider;
    private static final int PREFERRED_WIDTH = 14;
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.ErrorStrip");

    public ErrorStrip(RSyntaxTextArea textArea) {
        this.textArea = textArea;
        this.listener = new Listener();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setLayout(null);
        this.addMouseListener(this.listener);
        this.setShowMarkedOccurrences(true);
        this.setShowMarkAll(true);
        this.setLevelThreshold(ParserNotice.Level.WARNING);
        this.setFollowCaret(true);
        this.setCaretMarkerColor(this.getDefaultCaretMarkerColor());
        this.setMarkerToolTipProvider(null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.textArea.addCaretListener(this.listener);
        this.textArea.addPropertyChangeListener("RSTA.parserNotices", this.listener);
        this.textArea.addPropertyChangeListener("RSTA.markOccurrences", this.listener);
        this.textArea.addPropertyChangeListener("RSTA.markedOccurrencesChanged", this.listener);
        this.textArea.addPropertyChangeListener("RTA.markAllOccurrencesChanged", this.listener);
        this.refreshMarkers();
    }

    @Override
    public void doLayout() {
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Marker m2 = (Marker)this.getComponent(i2);
            m2.updateLocation();
        }
        this.listener.caretUpdate(null);
    }

    private Color getBrighterColor(Color c2) {
        Color brighter;
        if (this.brighterColors == null) {
            this.brighterColors = new HashMap<Color, Color>(5);
        }
        if ((brighter = this.brighterColors.get(c2)) == null) {
            int r2 = ErrorStrip.possiblyBrighter(c2.getRed());
            int g2 = ErrorStrip.possiblyBrighter(c2.getGreen());
            int b2 = ErrorStrip.possiblyBrighter(c2.getBlue());
            brighter = new Color(r2, g2, b2);
            this.brighterColors.put(c2, brighter);
        }
        return brighter;
    }

    public Color getCaretMarkerColor() {
        return this.caretMarkerColor;
    }

    private ColorUIResource getDefaultCaretMarkerColor() {
        if (RSyntaxUtilities.isLightForeground(this.getForeground())) {
            return new ColorUIResource(this.textArea.getCaretColor());
        }
        return new ColorUIResource(Color.BLACK);
    }

    public boolean getFollowCaret() {
        return this.followCaret;
    }

    @Override
    public Dimension getPreferredSize() {
        int height = this.textArea.getPreferredScrollableViewportSize().height;
        return new Dimension(14, height);
    }

    public ParserNotice.Level getLevelThreshold() {
        return this.levelThreshold;
    }

    public boolean getShowMarkAll() {
        return this.showMarkAll;
    }

    public boolean getShowMarkedOccurrences() {
        return this.showMarkedOccurrences;
    }

    @Override
    public String getToolTipText(MouseEvent e2) {
        String text = null;
        int line = this.yToLine(e2.getY());
        if (line > -1) {
            text = MSG.getString("Line");
            text = MessageFormat.format(text, line + 1);
        }
        return text;
    }

    private int lineToY(int line) {
        int h2 = this.textArea.getVisibleRect().height;
        float lineCount = this.textArea.getLineCount();
        return (int)((float)(line - 1) / (lineCount - 1.0f) * (float)(h2 - 2));
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.caretLineY > -1) {
            g2.setColor(this.getCaretMarkerColor());
            g2.fillRect(0, this.caretLineY, this.getWidth(), 2);
        }
    }

    private static int possiblyBrighter(int i2) {
        if (i2 < 255) {
            i2 += (int)((float)(255 - i2) * 0.8f);
        }
        return i2;
    }

    private void refreshMarkers() {
        this.removeAll();
        HashMap<Integer, Marker> markerMap = new HashMap<Integer, Marker>();
        List<ParserNotice> notices = this.textArea.getParserNotices();
        for (ParserNotice notice : notices) {
            if (!notice.getLevel().isEqualToOrWorseThan(this.levelThreshold) && !(notice instanceof TaskTagParser.TaskNotice)) continue;
            Integer key = notice.getLine();
            Marker m2 = (Marker)markerMap.get(key);
            if (m2 == null) {
                m2 = new Marker(notice);
                m2.addMouseListener(this.listener);
                markerMap.put(key, m2);
                this.add(m2);
                continue;
            }
            m2.addNotice(notice);
        }
        if (this.getShowMarkedOccurrences() && this.textArea.getMarkOccurrences()) {
            List<DocumentRange> occurrences = this.textArea.getMarkedOccurrences();
            this.addMarkersForRanges(occurrences, markerMap, this.textArea.getMarkOccurrencesColor());
        }
        if (this.getShowMarkAll()) {
            Color markAllColor = this.textArea.getMarkAllHighlightColor();
            List<DocumentRange> ranges = this.textArea.getMarkAllHighlightRanges();
            this.addMarkersForRanges(ranges, markerMap, markAllColor);
        }
        this.revalidate();
        this.repaint();
    }

    private void addMarkersForRanges(List<DocumentRange> ranges, Map<Integer, Marker> markerMap, Color color) {
        for (DocumentRange range : ranges) {
            int line = 0;
            try {
                line = this.textArea.getLineOfOffset(range.getStartOffset());
            }
            catch (BadLocationException ble) {
                continue;
            }
            MarkedOccurrenceNotice notice = new MarkedOccurrenceNotice(range, color);
            Integer key = line;
            Marker m2 = markerMap.get(key);
            if (m2 == null) {
                m2 = new Marker(notice);
                m2.addMouseListener(this.listener);
                markerMap.put(key, m2);
                this.add(m2);
                continue;
            }
            if (m2.containsMarkedOccurence()) continue;
            m2.addNotice(notice);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.textArea.removeCaretListener(this.listener);
        this.textArea.removePropertyChangeListener("RSTA.parserNotices", this.listener);
        this.textArea.removePropertyChangeListener("RSTA.markOccurrences", this.listener);
        this.textArea.removePropertyChangeListener("RSTA.markedOccurrencesChanged", this.listener);
        this.textArea.removePropertyChangeListener("RTA.markAllOccurrencesChanged", this.listener);
    }

    public void setCaretMarkerColor(Color color) {
        if (color != null) {
            this.caretMarkerColor = color;
            this.listener.caretUpdate(null);
        }
    }

    public void setFollowCaret(boolean follow) {
        if (this.followCaret != follow) {
            if (this.followCaret) {
                this.repaint(0, this.caretLineY, this.getWidth(), 2);
            }
            this.caretLineY = -1;
            this.lastLineY = -1;
            this.followCaret = follow;
            this.listener.caretUpdate(null);
        }
    }

    public void setLevelThreshold(ParserNotice.Level level) {
        this.levelThreshold = level;
        if (this.isDisplayable()) {
            this.refreshMarkers();
        }
    }

    public void setMarkerToolTipProvider(ErrorStripMarkerToolTipProvider provider) {
        this.markerToolTipProvider = provider != null ? provider : new DefaultErrorStripMarkerToolTipProvider();
    }

    public void setShowMarkAll(boolean show) {
        if (show != this.showMarkAll) {
            this.showMarkAll = show;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    public void setShowMarkedOccurrences(boolean show) {
        if (show != this.showMarkedOccurrences) {
            this.showMarkedOccurrences = show;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.caretMarkerColor instanceof ColorUIResource) {
            this.setCaretMarkerColor(this.getDefaultCaretMarkerColor());
        }
    }

    private int yToLine(int y2) {
        int line = -1;
        int h2 = this.textArea.getVisibleRect().height;
        if (y2 < h2) {
            float at2 = (float)y2 / (float)h2;
            line = Math.round((float)(this.textArea.getLineCount() - 1) * at2);
        }
        return line;
    }

    private class Marker
    extends JComponent {
        private List<ParserNotice> notices = new ArrayList<ParserNotice>(1);

        Marker(ParserNotice notice) {
            this.addNotice(notice);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setSize(this.getPreferredSize());
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void addNotice(ParserNotice notice) {
            this.notices.add(notice);
        }

        public boolean containsMarkedOccurence() {
            boolean result = false;
            for (ParserNotice notice : this.notices) {
                if (!(notice instanceof MarkedOccurrenceNotice)) continue;
                result = true;
                break;
            }
            return result;
        }

        public Color getColor() {
            Color c2 = null;
            int lowestLevel = Integer.MAX_VALUE;
            for (ParserNotice notice : this.notices) {
                if (notice.getLevel().getNumericValue() >= lowestLevel) continue;
                lowestLevel = notice.getLevel().getNumericValue();
                c2 = notice.getColor();
            }
            return c2;
        }

        @Override
        public Dimension getPreferredSize() {
            int w2 = 10;
            return new Dimension(w2, 5);
        }

        @Override
        public String getToolTipText() {
            return ErrorStrip.this.markerToolTipProvider.getToolTipText(Collections.unmodifiableList(this.notices));
        }

        protected void mouseClicked(MouseEvent e2) {
            ParserNotice pn = this.notices.get(0);
            int offs = pn.getOffset();
            int len = pn.getLength();
            if (offs > -1 && len > -1) {
                DocumentRange range = new DocumentRange(offs, offs + len);
                RSyntaxUtilities.selectAndPossiblyCenter(ErrorStrip.this.textArea, range, true);
            } else {
                int line = pn.getLine();
                try {
                    offs = ErrorStrip.this.textArea.getLineStartOffset(line);
                    ErrorStrip.this.textArea.getFoldManager().ensureOffsetNotInClosedFold(offs);
                    ErrorStrip.this.textArea.setCaretPosition(offs);
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g2) {
            Color borderColor = this.getColor();
            if (borderColor == null) {
                borderColor = Color.DARK_GRAY;
            }
            Color fillColor = ErrorStrip.this.getBrighterColor(borderColor);
            int w2 = this.getWidth();
            int h2 = this.getHeight();
            g2.setColor(fillColor);
            g2.fillRect(0, 0, w2, h2);
            g2.setColor(borderColor);
            g2.drawRect(0, 0, w2 - 1, h2 - 1);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.removeMouseListener(ErrorStrip.this.listener);
        }

        public void updateLocation() {
            int line = this.notices.get(0).getLine();
            int y2 = ErrorStrip.this.lineToY(line);
            this.setLocation(2, y2);
        }
    }

    private class MarkedOccurrenceNotice
    implements ParserNotice {
        private DocumentRange range;
        private Color color;

        MarkedOccurrenceNotice(DocumentRange range, Color color) {
            this.range = range;
            this.color = color;
        }

        @Override
        public int compareTo(ParserNotice other) {
            return 0;
        }

        @Override
        public boolean containsPosition(int pos) {
            return pos >= this.range.getStartOffset() && pos < this.range.getEndOffset();
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof ParserNotice)) {
                return false;
            }
            return this.compareTo((ParserNotice)o2) == 0;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public boolean getKnowsOffsetAndLength() {
            return true;
        }

        @Override
        public int getLength() {
            return this.range.getEndOffset() - this.range.getStartOffset();
        }

        @Override
        public ParserNotice.Level getLevel() {
            return ParserNotice.Level.INFO;
        }

        @Override
        public int getLine() {
            try {
                return ErrorStrip.this.textArea.getLineOfOffset(this.range.getStartOffset()) + 1;
            }
            catch (BadLocationException ble) {
                return 0;
            }
        }

        @Override
        public String getMessage() {
            String text = null;
            try {
                String word = ErrorStrip.this.textArea.getText(this.range.getStartOffset(), this.getLength());
                text = MSG.getString("OccurrenceOf");
                text = MessageFormat.format(text, word);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
            }
            return text;
        }

        @Override
        public int getOffset() {
            return this.range.getStartOffset();
        }

        @Override
        public Parser getParser() {
            return null;
        }

        @Override
        public boolean getShowInEditor() {
            return false;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        public int hashCode() {
            return 0;
        }
    }

    private class Listener
    extends MouseAdapter
    implements PropertyChangeListener,
    CaretListener {
        private Rectangle visibleRect = new Rectangle();

        private Listener() {
        }

        @Override
        public void caretUpdate(CaretEvent e2) {
            if (ErrorStrip.this.getFollowCaret()) {
                int line = ErrorStrip.this.textArea.getCaretLineNumber();
                float percent = (float)line / (float)(ErrorStrip.this.textArea.getLineCount() - 1);
                ErrorStrip.this.textArea.computeVisibleRect(this.visibleRect);
                ErrorStrip.this.caretLineY = (int)((float)this.visibleRect.height * percent);
                if (ErrorStrip.this.caretLineY != ErrorStrip.this.lastLineY) {
                    ErrorStrip.this.repaint(0, ErrorStrip.this.lastLineY, ErrorStrip.this.getWidth(), 2);
                    ErrorStrip.this.repaint(0, ErrorStrip.this.caretLineY, ErrorStrip.this.getWidth(), 2);
                    ErrorStrip.this.lastLineY = ErrorStrip.this.caretLineY;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            Component source = (Component)e2.getSource();
            if (source instanceof Marker) {
                ((Marker)source).mouseClicked(e2);
                return;
            }
            int line = ErrorStrip.this.yToLine(e2.getY());
            if (line > -1) {
                try {
                    int offs = ErrorStrip.this.textArea.getLineStartOffset(line);
                    ErrorStrip.this.textArea.setCaretPosition(offs);
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propName = e2.getPropertyName();
            if ("RSTA.markOccurrences".equals(propName)) {
                if (ErrorStrip.this.getShowMarkedOccurrences()) {
                    ErrorStrip.this.refreshMarkers();
                }
            } else if ("RSTA.parserNotices".equals(propName)) {
                ErrorStrip.this.refreshMarkers();
            } else if ("RSTA.markedOccurrencesChanged".equals(propName)) {
                if (ErrorStrip.this.getShowMarkedOccurrences()) {
                    ErrorStrip.this.refreshMarkers();
                }
            } else if ("RTA.markAllOccurrencesChanged".equals(propName) && ErrorStrip.this.getShowMarkAll()) {
                ErrorStrip.this.refreshMarkers();
            }
        }
    }

    public static interface ErrorStripMarkerToolTipProvider {
        public String getToolTipText(List<ParserNotice> var1);
    }

    private static class DefaultErrorStripMarkerToolTipProvider
    implements ErrorStripMarkerToolTipProvider {
        private DefaultErrorStripMarkerToolTipProvider() {
        }

        @Override
        public String getToolTipText(List<ParserNotice> notices) {
            String text;
            if (notices.size() == 1) {
                text = notices.get(0).getMessage();
            } else {
                StringBuilder sb = new StringBuilder("<html>");
                sb.append(MSG.getString("MultipleMarkers"));
                sb.append("<br>");
                for (ParserNotice pn : notices) {
                    sb.append("&nbsp;&nbsp;&nbsp;- ");
                    sb.append(pn.getMessage());
                    sb.append("<br>");
                }
                text = sb.toString();
            }
            return text;
        }
    }
}

