/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public final class RSyntaxUtilities
implements SwingConstants {
    public static final int OS_WINDOWS = 1;
    public static final int OS_MAC_OSX = 2;
    public static final int OS_LINUX = 4;
    public static final int OS_OTHER = 8;
    private static final Color LIGHT_HYPERLINK_FG = new Color(0xD8FFFF);
    private static final int OS = RSyntaxUtilities.getOSImpl();
    private static final int LETTER_MASK = 2;
    private static final int HEX_CHARACTER_MASK = 16;
    private static final int LETTER_OR_DIGIT_MASK = 32;
    private static final int BRACKET_MASK = 64;
    private static final int JAVA_OPERATOR_MASK = 128;
    private static final int[] DATA_TABLE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 128, 0, 0, 0, 128, 128, 0, 64, 64, 128, 128, 0, 128, 0, 128, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 128, 0, 128, 128, 128, 128, 0, 58, 58, 58, 58, 58, 58, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 64, 0, 64, 128, 0, 0, 50, 50, 50, 50, 50, 50, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 64, 128, 64, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Segment charSegment = new Segment();
    private static final TokenImpl TEMP_TOKEN = new TokenImpl();
    private static final char[] JS_KEYWORD_RETURN = new char[]{'r', 'e', 't', 'u', 'r', 'n'};
    private static final char[] JS_AND = new char[]{'&', '&'};
    private static final char[] JS_OR = new char[]{'|', '|'};
    private static final String BRACKETS = "{([})]";

    private RSyntaxUtilities() {
    }

    public static String escapeForHtml(String s2, String newlineReplacement, boolean inPreBlock) {
        if (s2 == null) {
            return null;
        }
        if (newlineReplacement == null) {
            newlineReplacement = "";
        }
        String tabString = "   ";
        boolean lastWasSpace = false;
        StringBuilder sb = new StringBuilder();
        block11: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char ch2 = s2.charAt(i2);
            switch (ch2) {
                case ' ': {
                    if (inPreBlock || !lastWasSpace) {
                        sb.append(' ');
                    } else {
                        sb.append("&nbsp;");
                    }
                    lastWasSpace = true;
                    continue block11;
                }
                case '\n': {
                    sb.append(newlineReplacement);
                    lastWasSpace = false;
                    continue block11;
                }
                case '&': {
                    sb.append("&amp;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '\t': {
                    sb.append("   ");
                    lastWasSpace = false;
                    continue block11;
                }
                case '<': {
                    sb.append("&lt;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '>': {
                    sb.append("&gt;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '\'': {
                    sb.append("&#39;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '\"': {
                    sb.append("&#34;");
                    lastWasSpace = false;
                    continue block11;
                }
                case '/': {
                    sb.append("&#47;");
                    lastWasSpace = false;
                    continue block11;
                }
                default: {
                    sb.append(ch2);
                    lastWasSpace = false;
                }
            }
        }
        return sb.toString();
    }

    public static Map<?, ?> getDesktopAntiAliasHints() {
        return (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    }

    public static Color getFoldedLineBottomColor(RSyntaxTextArea textArea) {
        Color color = Color.GRAY;
        Gutter gutter = RSyntaxUtilities.getGutter(textArea);
        if (gutter != null) {
            color = gutter.getFoldIndicatorForeground();
        }
        return color;
    }

    public static Gutter getGutter(RTextArea textArea) {
        Gutter gutter = null;
        Container parent = textArea.getParent();
        if (parent instanceof JViewport && (parent = parent.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane sp = (RTextScrollPane)parent;
            gutter = sp.getGutter();
        }
        return gutter;
    }

    public static Color getHyperlinkForeground() {
        Color fg2 = UIManager.getColor("Label.foreground");
        if (fg2 == null) {
            fg2 = new JLabel().getForeground();
        }
        return RSyntaxUtilities.isLightForeground(fg2) ? LIGHT_HYPERLINK_FG : Color.blue;
    }

    public static String getLeadingWhitespace(String text) {
        int count;
        int len = text.length();
        for (count = 0; count < len && RSyntaxUtilities.isWhitespace(text.charAt(count)); ++count) {
        }
        return text.substring(0, count);
    }

    public static String getLeadingWhitespace(Document doc, int offs) throws BadLocationException {
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offs);
        Element elem = root.getElement(line);
        int startOffs = elem.getStartOffset();
        int endOffs = elem.getEndOffset() - 1;
        String text = doc.getText(startOffs, endOffs - startOffs);
        return RSyntaxUtilities.getLeadingWhitespace(text);
    }

    private static Element getLineElem(Document doc, int offs) {
        int line;
        Element root = doc.getDefaultRootElement();
        Element elem = root.getElement(line = root.getElementIndex(offs));
        if (offs >= elem.getStartOffset() && offs < elem.getEndOffset()) {
            return elem;
        }
        return null;
    }

    public static Rectangle getLineWidthUpTo(RSyntaxTextArea textArea, Segment s2, int p0, int p1, TabExpander e2, Rectangle rect, int x0) throws BadLocationException {
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        if (p0 < 0) {
            throw new BadLocationException("Invalid document position", p0);
        }
        if (p1 > doc.getLength()) {
            throw new BadLocationException("Invalid document position", p1);
        }
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(p0);
        if (Math.abs(lineNum - map.getElementIndex(p1)) > 1) {
            throw new IllegalArgumentException("p0 and p1 are not on the same line (" + p0 + ", " + p1 + ").");
        }
        Token t2 = doc.getTokenListForLine(lineNum);
        TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(t2, p0, e2, textArea, 0.0f, TEMP_TOKEN);
        t2 = subList.tokenList;
        rect = t2.listOffsetToView(textArea, e2, p1, x0, rect);
        return rect;
    }

    public static Point getMatchingBracketPosition(RSyntaxTextArea textArea, Point input) {
        if (input == null) {
            input = new Point();
        }
        input.setLocation(-1, -1);
        try {
            char bracketMatch;
            boolean goForward;
            int index;
            int caretPosition = textArea.getCaretPosition() - 1;
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            char bracket = '\u0000';
            if (caretPosition >= 0) {
                bracket = doc.charAt(caretPosition);
            }
            if ((index = BRACKETS.indexOf(bracket)) == -1 && caretPosition < doc.getLength() - 1) {
                bracket = doc.charAt(++caretPosition);
            }
            if (index == -1 && (index = BRACKETS.indexOf(bracket)) == -1) {
                return input;
            }
            Element map = doc.getDefaultRootElement();
            int curLine = map.getElementIndex(caretPosition);
            Element line = map.getElement(curLine);
            int start = line.getStartOffset();
            int end = line.getEndOffset();
            Token token = doc.getTokenListForLine(curLine);
            if ((token = RSyntaxUtilities.getTokenAtOffset(token, caretPosition)).getType() != 22) {
                return input;
            }
            int languageIndex = token.getLanguageIndex();
            if (index < 3) {
                goForward = true;
                bracketMatch = BRACKETS.charAt(index + 3);
            } else {
                goForward = false;
                bracketMatch = BRACKETS.charAt(index - 3);
            }
            if (goForward) {
                int lastLine = map.getElementCount();
                start = caretPosition + 1;
                int numEmbedded = 0;
                boolean haveTokenList = false;
                while (true) {
                    int segOffset;
                    doc.getText(start, end - start, charSegment);
                    for (int i2 = segOffset = RSyntaxUtilities.charSegment.offset; i2 < segOffset + RSyntaxUtilities.charSegment.count; ++i2) {
                        int offset;
                        char ch2 = RSyntaxUtilities.charSegment.array[i2];
                        if (ch2 == bracket) {
                            if (!haveTokenList) {
                                token = doc.getTokenListForLine(curLine);
                                haveTokenList = true;
                            }
                            if ((token = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i2 - segOffset))).getType() != 22 || token.getLanguageIndex() != languageIndex) continue;
                            ++numEmbedded;
                            continue;
                        }
                        if (ch2 != bracketMatch) continue;
                        if (!haveTokenList) {
                            token = doc.getTokenListForLine(curLine);
                            haveTokenList = true;
                        }
                        if ((token = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i2 - segOffset))).getType() != 22 || token.getLanguageIndex() != languageIndex) continue;
                        if (numEmbedded == 0) {
                            if (textArea.isCodeFoldingEnabled() && textArea.getFoldManager().isLineHidden(curLine)) {
                                return input;
                            }
                            input.setLocation(caretPosition, offset);
                            return input;
                        }
                        --numEmbedded;
                    }
                    if (++curLine == lastLine) {
                        return input;
                    }
                    haveTokenList = false;
                    line = map.getElement(curLine);
                    start = line.getStartOffset();
                    end = line.getEndOffset();
                }
            }
            end = caretPosition;
            int numEmbedded = 0;
            boolean haveTokenList = false;
            while (true) {
                int iStart;
                doc.getText(start, end - start, charSegment);
                int segOffset = RSyntaxUtilities.charSegment.offset;
                for (int i3 = iStart = segOffset + RSyntaxUtilities.charSegment.count - 1; i3 >= segOffset; --i3) {
                    int offset;
                    Token t2;
                    char ch3 = RSyntaxUtilities.charSegment.array[i3];
                    if (ch3 == bracket) {
                        if (!haveTokenList) {
                            token = doc.getTokenListForLine(curLine);
                            haveTokenList = true;
                        }
                        if ((t2 = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i3 - segOffset))).getType() != 22 || token.getLanguageIndex() != languageIndex) continue;
                        ++numEmbedded;
                        continue;
                    }
                    if (ch3 != bracketMatch) continue;
                    if (!haveTokenList) {
                        token = doc.getTokenListForLine(curLine);
                        haveTokenList = true;
                    }
                    if ((t2 = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i3 - segOffset))).getType() != 22 || token.getLanguageIndex() != languageIndex) continue;
                    if (numEmbedded == 0) {
                        input.setLocation(caretPosition, offset);
                        return input;
                    }
                    --numEmbedded;
                }
                if (--curLine == -1) {
                    return input;
                }
                haveTokenList = false;
                line = map.getElement(curLine);
                start = line.getStartOffset();
                end = line.getEndOffset();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return input;
        }
    }

    public static Token getNextImportantToken(Token t2, RSyntaxTextArea textArea, int line) {
        while (t2 != null && t2.isPaintable() && t2.isCommentOrWhitespace()) {
            t2 = t2.getNextToken();
        }
        if (!(t2 != null && t2.isPaintable() || line >= textArea.getLineCount() - 1)) {
            t2 = textArea.getTokenListForLine(++line);
            return RSyntaxUtilities.getNextImportantToken(t2, textArea, line);
        }
        return t2;
    }

    public static int getNextVisualPositionFrom(int pos, Position.Bias b2, Shape a2, int direction, Position.Bias[] biasRet, View view) throws BadLocationException {
        RSyntaxTextArea target = (RSyntaxTextArea)view.getContainer();
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 1: 
            case 5: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 1 ? Math.max(0, view.getEndOffset() - 1) : view.getStartOffset();
                    break;
                }
                Caret c2 = target != null ? target.getCaret() : null;
                Point mcp = c2 != null ? c2.getMagicCaretPosition() : null;
                int x2 = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
                if (direction == 1) {
                    pos = RSyntaxUtilities.getPositionAbove(target, pos, x2, (TabExpander)((Object)view));
                    break;
                }
                pos = RSyntaxUtilities.getPositionBelow(target, pos, x2, (TabExpander)((Object)view));
                break;
            }
            case 7: {
                FoldManager fm2;
                int current;
                int last;
                int endOffs = view.getEndOffset();
                if (pos == -1) {
                    pos = Math.max(0, endOffs - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                if (!target.isCodeFoldingEnabled() || (last = pos == endOffs - 1 ? target.getLineCount() - 1 : target.getLineOfOffset(pos + 1)) == (current = target.getLineOfOffset(pos)) || !(fm2 = target.getFoldManager()).isLineHidden(current)) break;
                while (--current > 0 && fm2.isLineHidden(current)) {
                }
                pos = target.getLineEndOffset(current) - 1;
                break;
            }
            case 3: {
                FoldManager fm3;
                int current;
                int last;
                if (pos == -1) {
                    pos = view.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, view.getDocument().getLength());
                if (!target.isCodeFoldingEnabled() || (last = pos == 0 ? 0 : target.getLineOfOffset(pos - 1)) == (current = target.getLineOfOffset(pos)) || !(fm3 = target.getFoldManager()).isLineHidden(current)) break;
                int lineCount = target.getLineCount();
                while (++current < lineCount && fm3.isLineHidden(current)) {
                }
                pos = current == lineCount ? target.getLineEndOffset(last) - 1 : target.getLineStartOffset(current);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    public static int getOS() {
        return OS;
    }

    private static int getOSImpl() {
        int os = 8;
        String osName = System.getProperty("os.name");
        if (osName != null) {
            os = (osName = osName.toLowerCase()).contains("windows") ? 1 : (osName.contains("mac os x") ? 2 : (osName.contains("linux") ? 4 : 8));
        }
        return os;
    }

    public static int getPatternFlags(boolean matchCase, int others) {
        if (!matchCase) {
            others |= 0x42;
        }
        return others;
    }

    public static int getPositionAbove(RSyntaxTextArea c2, int offs, float x2, TabExpander e2) throws BadLocationException {
        TokenOrientedView tov = (TokenOrientedView)((Object)e2);
        Token token = tov.getTokenListForPhysicalLineAbove(offs);
        if (token == null) {
            return -1;
        }
        if (token.getType() == 0) {
            int line = c2.getLineOfOffset(offs);
            return c2.getLineStartOffset(line - 1);
        }
        return token.getListOffset(c2, e2, c2.getMargin().left, x2);
    }

    public static int getPositionBelow(RSyntaxTextArea c2, int offs, float x2, TabExpander e2) throws BadLocationException {
        TokenOrientedView tov = (TokenOrientedView)((Object)e2);
        Token token = tov.getTokenListForPhysicalLineBelow(offs);
        if (token == null) {
            return -1;
        }
        if (token.getType() == 0) {
            int line = c2.getLineOfOffset(offs);
            FoldManager fm2 = c2.getFoldManager();
            line = fm2.getVisibleLineBelow(line);
            return c2.getLineStartOffset(line);
        }
        return token.getListOffset(c2, e2, c2.getMargin().left, x2);
    }

    public static Token getPreviousImportantToken(RSyntaxDocument doc, int line) {
        if (line < 0) {
            return null;
        }
        Token t2 = doc.getTokenListForLine(line);
        if (t2 != null && (t2 = t2.getLastNonCommentNonWhitespaceToken()) != null) {
            return t2;
        }
        return RSyntaxUtilities.getPreviousImportantToken(doc, line - 1);
    }

    public static Token getPreviousImportantTokenFromOffs(RSyntaxDocument doc, int offs) {
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offs);
        Token target = null;
        for (Token t2 = doc.getTokenListForLine(line); t2 != null && t2.isPaintable() && !t2.containsPosition(offs); t2 = t2.getNextToken()) {
            if (t2.isCommentOrWhitespace()) continue;
            target = t2;
        }
        if (target == null) {
            target = RSyntaxUtilities.getPreviousImportantToken(doc, line - 1);
        }
        return target;
    }

    public static Token getTokenAtOffset(RSyntaxTextArea textArea, int offset) {
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        return RSyntaxUtilities.getTokenAtOffset(doc, offset);
    }

    public static Token getTokenAtOffset(RSyntaxDocument doc, int offset) {
        Element root = doc.getDefaultRootElement();
        int lineIndex = root.getElementIndex(offset);
        Token t2 = doc.getTokenListForLine(lineIndex);
        return RSyntaxUtilities.getTokenAtOffset(t2, offset);
    }

    public static Token getTokenAtOffset(Token tokenList, int offset) {
        for (Token t2 = tokenList; t2 != null && t2.isPaintable(); t2 = t2.getNextToken()) {
            if (!t2.containsPosition(offset)) continue;
            return t2;
        }
        return null;
    }

    public static int getWordEnd(RSyntaxTextArea textArea, int offs) throws BadLocationException {
        Document doc = textArea.getDocument();
        int endOffs = textArea.getLineEndOffsetOfCurrentLine();
        int lineEnd = Math.min(endOffs, doc.getLength());
        if (offs == lineEnd) {
            return offs;
        }
        String s2 = doc.getText(offs, lineEnd - offs - 1);
        if (s2 != null && s2.length() > 0) {
            int i2 = 0;
            int count = s2.length();
            char ch2 = s2.charAt(i2);
            if (Character.isWhitespace(ch2)) {
                while (i2 < count && Character.isWhitespace(s2.charAt(i2++))) {
                }
            } else if (Character.isLetterOrDigit(ch2)) {
                while (i2 < count && Character.isLetterOrDigit(s2.charAt(i2++))) {
                }
            } else {
                i2 = 2;
            }
            offs += i2 - 1;
        }
        return offs;
    }

    public static int getWordStart(RSyntaxTextArea textArea, int offs) throws BadLocationException {
        Document doc = textArea.getDocument();
        Element line = RSyntaxUtilities.getLineElem(doc, offs);
        if (line == null) {
            throw new BadLocationException("No word at " + offs, offs);
        }
        int lineStart = line.getStartOffset();
        if (offs == lineStart) {
            return offs;
        }
        int endOffs = Math.min(offs + 1, doc.getLength());
        String s2 = doc.getText(lineStart, endOffs - lineStart);
        if (s2 != null && s2.length() > 0) {
            int i2 = s2.length() - 1;
            char ch2 = s2.charAt(i2);
            if (Character.isWhitespace(ch2)) {
                while (i2 > 0 && Character.isWhitespace(s2.charAt(i2 - 1))) {
                    --i2;
                }
                offs = lineStart + i2;
            } else if (Character.isLetterOrDigit(ch2)) {
                while (i2 > 0 && Character.isLetterOrDigit(s2.charAt(i2 - 1))) {
                    --i2;
                }
                offs = lineStart + i2;
            }
        }
        return offs;
    }

    public static float getTokenListWidth(Token tokenList, RSyntaxTextArea textArea, TabExpander e2) {
        return RSyntaxUtilities.getTokenListWidth(tokenList, textArea, e2, 0.0f);
    }

    public static float getTokenListWidth(Token tokenList, RSyntaxTextArea textArea, TabExpander e2, float x0) {
        float width = x0;
        for (Token t2 = tokenList; t2 != null && t2.isPaintable(); t2 = t2.getNextToken()) {
            width += t2.getWidth(textArea, e2, width);
        }
        return width - x0;
    }

    public static float getTokenListWidthUpTo(Token tokenList, RSyntaxTextArea textArea, TabExpander e2, float x0, int upTo) {
        float width = 0.0f;
        for (Token t2 = tokenList; t2 != null && t2.isPaintable(); t2 = t2.getNextToken()) {
            if (t2.containsPosition(upTo)) {
                return width + t2.getWidthUpTo(upTo - t2.getOffset(), textArea, e2, x0 + width);
            }
            width += t2.getWidth(textArea, e2, x0 + width);
        }
        return width;
    }

    public static boolean isBracket(char ch2) {
        return ch2 <= '}' && (DATA_TABLE[ch2] & 0x40) > 0;
    }

    public static boolean isDigit(char ch2) {
        return ch2 >= '0' && ch2 <= '9';
    }

    public static boolean isHexCharacter(char ch2) {
        return ch2 <= 'f' && (DATA_TABLE[ch2] & 0x10) > 0;
    }

    public static boolean isJavaOperator(char ch2) {
        return ch2 <= '~' && (DATA_TABLE[ch2] & 0x80) > 0;
    }

    public static boolean isLetter(char ch2) {
        return ch2 <= 'z' && (DATA_TABLE[ch2] & 2) > 0;
    }

    public static boolean isLetterOrDigit(char ch2) {
        return ch2 <= 'z' && (DATA_TABLE[ch2] & 0x20) > 0;
    }

    public static boolean isLightForeground(Color fg2) {
        return fg2.getRed() > 160 && fg2.getGreen() > 160 && fg2.getBlue() > 160;
    }

    public static boolean isNonWordChar(Token t2) {
        return t2.length() == 1 && !RSyntaxUtilities.isLetter(t2.charAt(0));
    }

    public static boolean isWhitespace(char ch2) {
        return ch2 == ' ' || ch2 == '\t';
    }

    public static void possiblyRepaintGutter(RTextArea textArea) {
        Gutter gutter = RSyntaxUtilities.getGutter(textArea);
        if (gutter != null) {
            gutter.repaint();
        }
    }

    public static boolean regexCanFollowInJavaScript(Token t2) {
        char ch2;
        return t2 == null || t2.length() == 1 && ((ch2 = t2.charAt(0)) == '=' || ch2 == '(' || ch2 == ',' || ch2 == '?' || ch2 == ':' || ch2 == '[' || ch2 == '!' || ch2 == '&') || t2.getType() == 23 && (t2.charAt(t2.length() - 1) == '=' || t2.is(JS_AND) || t2.is(JS_OR)) || t2.is(7, JS_KEYWORD_RETURN);
    }

    public static void selectAndPossiblyCenter(JTextArea textArea, DocumentRange range, boolean select) {
        Rectangle r2;
        RSyntaxTextArea rsta;
        FoldManager fm2;
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        boolean foldsExpanded = false;
        if (textArea instanceof RSyntaxTextArea && (fm2 = (rsta = (RSyntaxTextArea)textArea).getFoldManager()).isCodeFoldingSupportedAndEnabled()) {
            foldsExpanded = fm2.ensureOffsetNotInClosedFold(start);
            foldsExpanded |= fm2.ensureOffsetNotInClosedFold(end);
        }
        if (select) {
            textArea.setSelectionStart(start);
            textArea.setSelectionEnd(end);
        }
        try {
            r2 = textArea.modelToView(start);
            if (r2 == null) {
                return;
            }
            if (end != start) {
                r2 = r2.union(textArea.modelToView(end));
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            if (select) {
                textArea.setSelectionStart(start);
                textArea.setSelectionEnd(end);
            }
            return;
        }
        Rectangle visible = textArea.getVisibleRect();
        if (!foldsExpanded && visible.contains(r2)) {
            if (select) {
                textArea.setSelectionStart(start);
                textArea.setSelectionEnd(end);
            }
            return;
        }
        visible.x = r2.x - (visible.width - r2.width) / 2;
        visible.y = r2.y - (visible.height - r2.height) / 2;
        Rectangle bounds = textArea.getBounds();
        Insets i2 = textArea.getInsets();
        bounds.x = i2.left;
        bounds.y = i2.top;
        bounds.width -= i2.left + i2.right;
        bounds.height -= i2.top + i2.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        textArea.scrollRectToVisible(visible);
    }

    public static char toLowerCase(char ch2) {
        if (ch2 >= 'A' && ch2 <= 'Z') {
            return (char)(ch2 | 0x20);
        }
        return ch2;
    }

    public static Pattern wildcardToPattern(String wildcard, boolean matchCase, boolean escapeStartChar) {
        Pattern p2;
        int flags = RSyntaxUtilities.getPatternFlags(matchCase, 0);
        StringBuilder sb = new StringBuilder();
        block8: for (int i2 = 0; i2 < wildcard.length(); ++i2) {
            char ch2 = wildcard.charAt(i2);
            switch (ch2) {
                case '*': {
                    sb.append(".*");
                    continue block8;
                }
                case '?': {
                    sb.append('.');
                    continue block8;
                }
                case '^': {
                    if (i2 > 0 || escapeStartChar) {
                        sb.append('\\');
                    }
                    sb.append('^');
                    continue block8;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\').append(ch2);
                    continue block8;
                }
                default: {
                    sb.append(ch2);
                }
            }
        }
        try {
            p2 = Pattern.compile(sb.toString(), flags);
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
            p2 = Pattern.compile(".+");
        }
        return p2;
    }
}

